<?php

if(!defined('DOKU_INC')) define('DOKU_INC',realpath(dirname(__FILE__).'/../../').'/');
require_once(DOKU_INC.'inc/init.php');
if(!defined('DOKU_PLUGIN')) define('DOKU_PLUGIN',DOKU_INC.'lib/plugins/');
require_once(DOKU_PLUGIN.'sbvr/lexer.php');


class PlGenerator{

	protected $lexer;
	protected $facts = array(); 

    public function __construct(){
        $this->lexer = new SbvrLexer();
    }

	public function generate($id){
		$this->prepareFacts(curNS($id));

		return $this->prepareFileContent();
	}

	private function prepareFacts($dir){
		$this->lexer->prepareTerms($dir);
		$this->lexer->prepareFacts($dir);
		$this->facts = $this->lexer->facts;
		if(count($this->facts)==0)
			return 'no facts';
	}

	private function prepareFileContent(){
		$fileText="";
		foreach($this->facts as $key => $fact){
			$verb=$fact['verb'];
			$term1=$fact['term1'];
			$term2=$fact['term2'];

			$verb=strtolower(str_replace(' ','_',$verb));
			$term1=strtolower(str_replace(' ','_',$term1));
			$term1=str_replace('-','_',$term1);
			$line="";
			if($term2!=""){
				$term2=strtolower(str_replace(' ','_',$term2));
				$term2=str_replace('-','_',$term2);
				$line=$verb."(".$term1.",".$term2."). \n";
			}
			else {
				$line=$verb."(".$term1."). \n";
			}
			if(stripos($fileText,$line)===false)
				$fileText.=$line;
		}
		return $fileText;
	}

}
