<?php

if(!defined('DOKU_INC')) define('DOKU_INC',realpath(dirname(__FILE__).'/../../').'/');
require_once(DOKU_INC.'inc/init.php');
if(!defined('DOKU_PLUGIN')) define('DOKU_PLUGIN',DOKU_INC.'lib/plugins/');
require_once(DOKU_PLUGIN.'sbvr/lexer.php');


class XMLGenerator{

	protected $lexer;
	protected $terms = array();
	protected $facts = array(); 
	protected $rules = array(); 

    public function __construct(){
        $this->lexer = new SbvrLexer();
    }

	public function generate($id){
		$this->prepareTerms(curNS($id));
		if(count($this->terms)==0)
			return 'no terms';
		$this->prepareFacts(curNS($id));
		if(count($this->facts)==0)
			return 'no facts';
		$this->prepareRules(curNS($id));
		if(count($this->rules)==0)
			return 'no rules';

		return $this->prepareFileContent($id);
	}

	private function prepareTerms($dir){
		$this->lexer->prepareTerms($dir);
		$this->terms = $this->lexer->terms;
	}
	
	private function prepareFacts($dir){
		$this->lexer->prepareFacts($dir);
		$this->facts = $this->lexer->facts;
	}

	private function prepareRules($dir){
		$this->lexer->prepareRules($dir);
		$this->rules = $this->lexer->rules;
	}

	private function prepareFileContent($id){
		$fileContent="";

//POCZĄTEK PLIKU
		$fileContent.='<?xml version="1.0" encoding="UTF-8"?> ';
		$fileContent.='<project id="'.curNS($id).'"> ';

//POCZĄTEK SŁOWNIKA TERMÓW
		$fileContent.='<terms_dictionary> ';

		$category="";
		foreach($this->terms as $key => $term){
			if($key==0){
				$category=$term['category'];
				$fileContent.='<category id="'.str_replace(" ","_",trim(strtolower($category))).'"> '.$category.' ';
			}
			elseif($term['category']!=$category){
				$category=$term['category'];
				$fileContent.='</category> ';
				$fileContent.='<category id="'.str_replace(" ","_",trim(strtolower($category))).'"> '.$category.' ';
			}
			
			$fileContent.='<term> '.$term['name'];
			if($term['attributes']!=null)
				foreach($term['attributes'] as $key=>$attr){
					$attrName=str_replace(" ","_",strtolower($attr[0]));
					$attrValue=$attr[1];
					$fileContent.='<attribute name="'.$attrName.'">'.$attrValue.'</attribute>';
				}

			$fileContent.='</term>';
		}
		$fileContent.="</category> </terms_dictionary>";

//POCZĄTEK SŁOWNIKA FAKTÓW
	$fileContent.='<facts_dictionary> ';

		$category="";
		foreach($this->facts as $key => $fact){
			if($key==0){
				$category=$fact['category'];
				$fileContent.='<category id="'.str_replace(" ","_",trim(strtolower($category))).'"> '.$category.' ';
			}
			elseif($fact['category']!=$category){
				$category=$fact['category'];
				$fileContent.='</category> ';
				$fileContent.='<category id="'.str_replace(" ","_",trim(strtolower($category))).'"> '.$category.' ';
			}
			
			$fileContent.='<fact> ';
			$fileContent.=$fact['term1'].' '.$fact['verb'].' '.$fact['term2'];
			$fileContent.='<verb>'.$fact['verb'].'</verb> ';
			$fileContent.='<term1>'.$fact['term1'].'</term1> ';
			$fileContent.='<term2>'.$fact['term2'].'</term2> ';

			$fileContent.='</fact>';
		}
		$fileContent.="</category> </facts_dictionary>";


//POCZĄTEK SŁOWNIKA REGUŁ
		$fileContent.='<rules_dictionary> ';

		$category="";
		foreach($this->rules as $key => $rules){
			if($key==0){
				$category=$rules['category'];
				$fileContent.='<category id="'.str_replace(" ","_",trim(strtolower($category))).'">'.$category.' ';
			}
			elseif($rules['category']!=$category){
				$category=$rules['category'];
				$fileContent.='</category> ';
				$fileContent.='<category id="'.str_replace(" ","_",trim(strtolower($category))).'">'.$category.' ';
			}
			
			$fileContent.='<rule> '.trim($rules['rule']);
			if($rules['tokens']!=null)
				foreach($rules['tokens'] as $key=>$token){
					$tokName=str_replace(" ","_",strtolower($token['token']));
					$tokValue=$token['match'];
					$fileContent.='<'.$tokName.'>'.$tokValue.'</'.$tokName.'>';
				}

			$fileContent.='</rule>';
		}
		$fileContent.="</category> </rules_dictionary>";

//KONIEC PLIKU
		$fileContent.='</project>';
		return $fileContent;
	}

}
