/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ProtectedCommand;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPSystem
implements Diagram {
    private UmlSource source;

    private String getVersion() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PlantUML version ");
        stringBuilder.append(Version.versionString());
        stringBuilder.append("(" + new Date(Version.compileTime()) + ")\n");
        stringBuilder.append("(" + (Object)((Object)License.getCurrent()) + " source distribution)\n");
        Properties properties = System.getProperties();
        stringBuilder.append(properties.getProperty("java.runtime.name"));
        stringBuilder.append('\n');
        stringBuilder.append(properties.getProperty("java.vm.name"));
        stringBuilder.append('\n');
        stringBuilder.append(properties.getProperty("java.runtime.version"));
        stringBuilder.append('\n');
        stringBuilder.append(properties.getProperty("os.name"));
        return stringBuilder.toString();
    }

    @Override
    public final String getMetadata() {
        if (this.source == null) {
            return this.getVersion();
        }
        return this.source.getPlainString() + "\n" + this.getVersion();
    }

    @Override
    public final UmlSource getSource() {
        return this.source;
    }

    public final void setSource(UmlSource umlSource) {
        this.source = umlSource;
    }

    @Override
    public int getNbImages() {
        return 1;
    }

    public Display getTitle() {
        if (this.source == null) {
            return Display.emptyList();
        }
        return this.source.getTitle();
    }

    @Override
    public String getWarningOrError() {
        return null;
    }

    public void makeDiagramReady() {
    }

    public boolean isOk() {
        return true;
    }

    public CommandExecutionResult executeCommand(Command protectedCommand, List<String> list) {
        protectedCommand = new ProtectedCommand(protectedCommand);
        return protectedCommand.execute(this, list);
    }
}

