/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionIf
implements Instruction {
    private final InstructionList thenList = new InstructionList();
    private final InstructionList elseList = new InstructionList();
    private final Instruction parent;
    private final Display labelTest;
    private final Display whenThen;
    private Display whenElse;
    private InstructionList current = this.thenList;
    private final LinkRendering inlinkRendering;
    private LinkRendering endThenInlinkRendering;
    private LinkRendering elseThenInlinkRendering;
    private boolean isThereElse = false;

    public InstructionIf(Instruction instruction, Display display, Display display2, LinkRendering linkRendering) {
        this.parent = instruction;
        this.labelTest = display;
        this.whenThen = display2;
        this.inlinkRendering = linkRendering;
    }

    @Override
    public void add(Instruction instruction) {
        this.current.add(instruction);
    }

    @Override
    public Ftile createFtile(FtileFactory ftileFactory) {
        return ftileFactory.createIf(ftileFactory.decorateOut(this.thenList.createFtile(ftileFactory), this.endThenInlinkRendering), ftileFactory.decorateOut(this.elseList.createFtile(ftileFactory), this.elseThenInlinkRendering), this.labelTest, this.whenThen, this.whenElse);
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void swithToElse(Display display, LinkRendering linkRendering) {
        this.whenElse = display;
        this.current = this.elseList;
        this.endThenInlinkRendering = linkRendering;
        this.isThereElse = true;
    }

    public void endif(LinkRendering linkRendering) {
        if (this.isThereElse) {
            this.elseThenInlinkRendering = linkRendering;
        } else {
            this.endThenInlinkRendering = linkRendering;
        }
    }

    @Override
    public final boolean kill() {
        return this.current.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }

    @Override
    public void addNote(Display display, NotePosition notePosition) {
        this.current.addNote(display, notePosition);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        hashSet.addAll(this.thenList.getSwimlanes());
        hashSet.addAll(this.elseList.getSwimlanes());
        return Collections.unmodifiableSet(hashSet);
    }
}

