/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileAssemblySimple
implements Ftile {
    private final Ftile tile1;
    private final Ftile tile2;

    public String toString() {
        return "FtileAssemblySimple " + this.tile1 + " && " + this.tile2;
    }

    public FtileAssemblySimple(Ftile ftile, Ftile ftile2) {
        this.tile1 = ftile;
        this.tile2 = ftile2;
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile2.getSwimlaneOut();
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.tile1) {
            return this.getTranslated1(stringBounder);
        }
        if (ftile == this.tile2) {
            return this.getTranslated2(stringBounder);
        }
        UTranslate uTranslate = this.tile1.getTranslateFor(ftile, stringBounder);
        if (uTranslate != null) {
            return uTranslate.compose(this.getTranslated1(stringBounder));
        }
        uTranslate = this.tile2.getTranslateFor(ftile, stringBounder);
        if (uTranslate != null) {
            return uTranslate.compose(this.getTranslated2(stringBounder));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBlock asTextBlock() {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                StringBounder stringBounder = uGraphic.getStringBounder();
                uGraphic.apply(FtileAssemblySimple.this.getTranslated1(stringBounder)).draw(FtileAssemblySimple.this.tile1);
                uGraphic.apply(FtileAssemblySimple.this.getTranslated2(stringBounder)).draw(FtileAssemblySimple.this.tile2);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = FtileAssemblySimple.this.tile1.asTextBlock().calculateDimension(stringBounder);
                Dimension2D dimension2D2 = FtileAssemblySimple.this.tile2.asTextBlock().calculateDimension(stringBounder);
                return Dimension2DDouble.mergeTB(dimension2D, dimension2D2);
            }

            @Override
            public List<Url> getUrls() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isKilled() {
        return this.tile2.isKilled();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.tile1.getInLinkRendering();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return null;
    }

    @Override
    public Point2D getPointIn(StringBounder stringBounder) {
        UTranslate uTranslate = this.getTranslated1(stringBounder);
        Point2D point2D = this.tile1.getPointIn(stringBounder);
        return uTranslate.getTranslated(point2D);
    }

    @Override
    public Point2D getPointOut(StringBounder stringBounder) {
        UTranslate uTranslate = this.getTranslated2(stringBounder);
        Point2D point2D = this.tile2.getPointOut(stringBounder);
        if (point2D == null) {
            return null;
        }
        return uTranslate.getTranslated(point2D);
    }

    private UTranslate getTranslated1(StringBounder stringBounder) {
        Dimension2D dimension2D = this.asTextBlock().calculateDimension(stringBounder);
        TextBlock textBlock = this.tile1.asTextBlock();
        Dimension2D dimension2D2 = textBlock.calculateDimension(stringBounder);
        double d = dimension2D.getWidth() - dimension2D2.getWidth();
        return new UTranslate(d / 2.0, 0.0);
    }

    private UTranslate getTranslated2(StringBounder stringBounder) {
        Dimension2D dimension2D = this.asTextBlock().calculateDimension(stringBounder);
        TextBlock textBlock = this.tile1.asTextBlock();
        TextBlock textBlock2 = this.tile2.asTextBlock();
        Dimension2D dimension2D2 = textBlock.calculateDimension(stringBounder);
        Dimension2D dimension2D3 = textBlock2.calculateDimension(stringBounder);
        double d = dimension2D.getWidth() - dimension2D3.getWidth();
        return new UTranslate(d / 2.0, dimension2D2.getHeight());
    }

    @Override
    public Collection<Connection> getInnerConnections() {
        return Collections.emptyList();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        hashSet.addAll(this.tile1.getSwimlanes());
        hashSet.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public boolean shadowing() {
        return this.tile1.shadowing() || this.tile2.shadowing();
    }
}

