/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileMinWidth
implements Ftile {
    private final Ftile ftile;
    private final double minWidth;

    public FtileMinWidth(Ftile ftile, double d) {
        this.ftile = ftile;
        this.minWidth = d;
    }

    public String toString() {
        return "FtileMinWidth:" + this.ftile;
    }

    @Override
    public TextBlock asTextBlock() {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                StringBounder stringBounder = uGraphic.getStringBounder();
                UTranslate uTranslate = FtileMinWidth.this.getUTranslateInternal(stringBounder);
                uGraphic.apply(uTranslate).draw(FtileMinWidth.this.ftile);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return FtileMinWidth.this.getDimensionInternal(stringBounder);
            }

            @Override
            public List<Url> getUrls() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private UTranslate getUTranslateInternal(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getDimension(stringBounder);
        Dimension2D dimension2D2 = this.getDimensionInternal(stringBounder);
        UTranslate uTranslate = new UTranslate((dimension2D2.getWidth() - dimension2D.getWidth()) / 2.0, 0.0);
        return uTranslate;
    }

    private Dimension2D getDimensionInternal(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getDimension(stringBounder);
        if (dimension2D.getWidth() < this.minWidth) {
            return new Dimension2DDouble(this.minWidth, dimension2D.getHeight());
        }
        return dimension2D;
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.ftile) {
            return this.getUTranslateInternal(stringBounder);
        }
        return null;
    }

    @Override
    public boolean isKilled() {
        return this.ftile.isKilled();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.ftile.getInLinkRendering();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return null;
    }

    private Dimension2D getDimension(StringBounder stringBounder) {
        return this.ftile.asTextBlock().calculateDimension(stringBounder);
    }

    private Point2D getPoint(Point2D point2D, StringBounder stringBounder) {
        Dimension2D dimension2D = this.getDimension(stringBounder);
        if (dimension2D.getWidth() < this.minWidth) {
            double d = this.minWidth - dimension2D.getWidth();
            return new Point2D.Double(point2D.getX() + d / 2.0, point2D.getY());
        }
        return point2D;
    }

    @Override
    public Point2D getPointIn(StringBounder stringBounder) {
        return this.getPoint(this.ftile.getPointIn(stringBounder), stringBounder);
    }

    @Override
    public Point2D getPointOut(StringBounder stringBounder) {
        return this.getPoint(this.ftile.getPointOut(stringBounder), stringBounder);
    }

    @Override
    public Collection<Connection> getInnerConnections() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.ftile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.ftile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.ftile.getSwimlaneOut();
    }

    @Override
    public boolean shadowing() {
        return this.ftile.shadowing();
    }
}

