/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FtileWithConnection
implements Ftile {
    private final Ftile ftile;
    private final List<Connection> connections = new ArrayList<Connection>();

    FtileWithConnection(Ftile ftile, Collection<Connection> collection) {
        if (collection == null || collection.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.ftile = ftile;
        this.connections.addAll(collection);
    }

    public String toString() {
        return "FtileWithConnection " + this.ftile + " " + this.connections;
    }

    public FtileWithConnection(Ftile ftile, Connection connection) {
        this(ftile, Arrays.asList(connection));
        if (connection == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        return this.ftile.getTranslateFor(ftile, stringBounder);
    }

    @Override
    public boolean isKilled() {
        return this.ftile.isKilled();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.ftile.getInLinkRendering();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return this.ftile.getOutLinkRendering();
    }

    @Override
    public Point2D getPointIn(StringBounder stringBounder) {
        return this.ftile.getPointIn(stringBounder);
    }

    @Override
    public Point2D getPointOut(StringBounder stringBounder) {
        return this.ftile.getPointOut(stringBounder);
    }

    @Override
    public TextBlock asTextBlock() {
        final TextBlock textBlock = this.ftile.asTextBlock();
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                textBlock.drawU(uGraphic);
                for (Connection connection : FtileWithConnection.this.connections) {
                    uGraphic.draw(connection);
                }
            }

            @Override
            public List<Url> getUrls() {
                return textBlock.getUrls();
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return textBlock.calculateDimension(stringBounder);
            }
        };
    }

    @Override
    public Collection<Connection> getInnerConnections() {
        ArrayList<Connection> arrayList = new ArrayList<Connection>(this.ftile.getInnerConnections());
        arrayList.addAll(this.connections);
        return Collections.unmodifiableList(this.connections);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.ftile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.ftile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.ftile.getSwimlaneOut();
    }

    @Override
    public boolean shadowing() {
        return this.ftile.shadowing();
    }
}

