/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.ftile.ULineMergeable;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Snake {
    private final List<Point2D.Double> points = new ArrayList<Point2D.Double>();
    private final UPolygon endDecoration;
    private final HtmlColor color;
    private final boolean mergeable;

    private Snake(HtmlColor htmlColor, UPolygon uPolygon, boolean bl) {
        this.endDecoration = uPolygon;
        this.color = htmlColor;
        this.mergeable = bl;
    }

    public Snake(HtmlColor htmlColor, UPolygon uPolygon) {
        this(htmlColor, uPolygon, false);
    }

    public Snake(HtmlColor htmlColor) {
        this(htmlColor, null, false);
    }

    public Snake(HtmlColor htmlColor, boolean bl) {
        this(htmlColor, null, bl);
    }

    public void addPoint(double d, double d2) {
        this.points.add(new Point2D.Double(d, d2));
    }

    public void addPoint(Point2D point2D) {
        this.addPoint(point2D.getX(), point2D.getY());
    }

    public void drawU(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(new UChangeColor(this.color));
        for (int i = 0; i < this.points.size() - 1; ++i) {
            this.drawLine(uGraphic.apply(new UStroke(1.5)), this.points.get(i), this.points.get(i + 1));
        }
        if (this.endDecoration != null) {
            uGraphic = uGraphic.apply(new UChangeBackColor(this.color));
            Point2D point2D = this.points.get(this.points.size() - 1);
            uGraphic.apply(new UTranslate(point2D)).apply(new UStroke()).draw(this.endDecoration);
        }
    }

    private void drawLine(UGraphic uGraphic, Point2D.Double double_, Point2D.Double double_2) {
        this.drawLine(uGraphic, double_.getX(), double_.getY(), double_2.getX(), double_2.getY());
    }

    private void drawLine(UGraphic uGraphic, double d, double d2, double d3, double d4) {
        uGraphic = uGraphic.apply(new UTranslate(d, d2));
        if (this.mergeable) {
            uGraphic.draw(new ULineMergeable(d3 - d, d4 - d2));
        } else {
            uGraphic.draw(new ULine(d3 - d, d4 - d2));
        }
    }
}

