/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionCross;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.ULineFlush;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAddNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAssembly;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorCreateFork;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorCreateGroup;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorCreateSplit;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorIf;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorRepeat;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorWhile;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.UGraphicInterceptorOneSwimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.VCompactFactory;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockInterceptorTextBlockable;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UGraphicDelegator;
import net.sourceforge.plantuml.svek.UGraphicLineMerger;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Swimlanes
implements TextBlock {
    private static final StringBounder dummyStringBounder;
    private final ISkinParam skinParam;
    private final List<Swimlane> swinlanes = new ArrayList<Swimlane>();
    private Swimlane currentSwimlane = null;
    private final Instruction root;
    private Instruction currentInstruction = this.root = new InstructionList();
    private LinkRendering nextLinkRenderer;

    public Swimlanes(ISkinParam iSkinParam) {
        this.skinParam = iSkinParam;
    }

    private FtileFactory getFtileFactory() {
        FtileFactory ftileFactory = new VCompactFactory(this.skinParam, dummyStringBounder);
        ftileFactory = new FtileFactoryDelegatorAssembly(ftileFactory, this.skinParam);
        ftileFactory = new FtileFactoryDelegatorIf(ftileFactory, this.skinParam);
        ftileFactory = new FtileFactoryDelegatorWhile(ftileFactory, this.skinParam);
        ftileFactory = new FtileFactoryDelegatorRepeat(ftileFactory, this.skinParam);
        ftileFactory = new FtileFactoryDelegatorCreateFork(ftileFactory, this.skinParam);
        ftileFactory = new FtileFactoryDelegatorCreateSplit(ftileFactory, this.skinParam);
        ftileFactory = new FtileFactoryDelegatorAddNote(ftileFactory, this.skinParam);
        ftileFactory = new FtileFactoryDelegatorCreateGroup(ftileFactory, this.skinParam);
        return ftileFactory;
    }

    public void swimlane(String string, HtmlColor htmlColor, Display display) {
        this.currentSwimlane = this.getOrCreate(string);
        if (htmlColor != null) {
            this.currentSwimlane.setSpecificBackcolor(htmlColor);
        }
        if (display != null) {
            this.currentSwimlane.setDisplay(display);
        }
    }

    private Swimlane getOrCreate(String string) {
        for (Swimlane swimlane : this.swinlanes) {
            if (!swimlane.getName().equals(string)) continue;
            return swimlane;
        }
        Swimlane swimlane = new Swimlane(string);
        this.swinlanes.add(swimlane);
        return swimlane;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        FtileFactory ftileFactory = this.getFtileFactory();
        TextBlock textBlock = this.root.createFtile(ftileFactory).asTextBlock();
        if (this.swinlanes.size() <= 1) {
            textBlock = new TextBlockInterceptorTextBlockable(textBlock);
            UGraphicLineMerger uGraphicLineMerger = new UGraphicLineMerger(uGraphic);
            textBlock.drawU(uGraphicLineMerger);
            uGraphicLineMerger.draw(new ULineFlush());
            return;
        }
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
        UFont uFont = this.skinParam.getFont(FontParam.TITLE, null);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        double d = 0.0;
        for (Swimlane swimlane : this.swinlanes) {
            TextBlock textBlock2 = TextBlockUtils.create(swimlane.getDisplay(), fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            d = Math.max(d, textBlock2.calculateDimension(stringBounder).getHeight());
        }
        double d2 = 0.0;
        UTranslate uTranslate = new UTranslate(0.0, d);
        for (Swimlane swimlane : this.swinlanes) {
            Object object;
            TextBlock textBlock3 = TextBlockUtils.create(swimlane.getDisplay(), fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            LimitFinder limitFinder = new LimitFinder(stringBounder, false);
            textBlock.drawU(new UGraphicInterceptorOneSwimlane(limitFinder, swimlane));
            MinMax minMax = limitFinder.getMinMax();
            double d3 = minMax.getWidth() + 20.0;
            double d4 = textBlock3.calculateDimension(stringBounder).getWidth();
            double d5 = Math.max(d3, d4 + 20.0);
            if (swimlane.getSpecificBackColor() != null) {
                object = uGraphic.apply(new UChangeBackColor(swimlane.getSpecificBackColor())).apply(new UChangeColor(swimlane.getSpecificBackColor())).apply(new UTranslate(d2, 0.0));
                object.draw(new URectangle(d5, dimension2D.getHeight() + d));
            }
            object = new UTranslate(d2 - minMax.getMinX() + 10.0 + (d5 - d3) / 2.0, 0.0);
            swimlane.setTranslate((UTranslate)object);
            double d6 = d2 + (d5 - d4) / 2.0;
            textBlock3.drawU(uGraphic.apply(new UTranslate(d6, 0.0)));
            this.drawSeparation(uGraphic.apply(new UTranslate(d2, 0.0)), dimension2D.getHeight() + d);
            UGraphicInterceptorOneSwimlane uGraphicInterceptorOneSwimlane = new UGraphicInterceptorOneSwimlane(uGraphic, swimlane);
            textBlock.drawU(uGraphicInterceptorOneSwimlane.apply((UChange)object).apply(uTranslate));
            d2 += d5;
        }
        this.drawSeparation(uGraphic.apply(new UTranslate(d2, 0.0)), dimension2D.getHeight() + d);
        textBlock.drawU(new Cross(uGraphic.apply(uTranslate)));
    }

    private void drawSeparation(UGraphic uGraphic, double d) {
        uGraphic.apply(new UStroke(2.0)).apply(new UChangeColor(HtmlColorUtils.BLACK)).draw(new ULine(0.0, d));
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return TextBlockUtils.getMinMax(this, stringBounder).getDimension();
    }

    @Override
    public List<Url> getUrls() {
        throw new UnsupportedOperationException();
    }

    public Instruction getCurrent() {
        return this.currentInstruction;
    }

    public void setCurrent(Instruction instruction) {
        this.currentInstruction = instruction;
    }

    public LinkRendering nextLinkRenderer() {
        return this.nextLinkRenderer;
    }

    public void setNextLinkRenderer(LinkRendering linkRendering) {
        this.nextLinkRenderer = linkRendering;
    }

    public Swimlane getCurrentSwimlane() {
        return this.currentSwimlane;
    }

    static {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
        dummyStringBounder = StringBounderUtils.asStringBounder(bufferedImage.createGraphics());
    }

    class Cross
    extends UGraphicDelegator {
        private Cross(UGraphic uGraphic) {
            super(uGraphic);
        }

        public void draw(UShape uShape) {
            if (uShape instanceof Ftile) {
                Ftile ftile = (Ftile)uShape;
                ftile.asTextBlock().drawU(this);
            } else if (uShape instanceof Connection) {
                Swimlane swimlane;
                Connection connection = (Connection)uShape;
                Ftile ftile = connection.getFtile1();
                Ftile ftile2 = connection.getFtile2();
                if (ftile == null || ftile2 == null) {
                    return;
                }
                Swimlane swimlane2 = ftile.getSwimlaneOut();
                if (swimlane2 != (swimlane = ftile2.getSwimlaneIn())) {
                    ConnectionCross connectionCross = new ConnectionCross(connection);
                    connectionCross.drawU(this.getUg());
                }
            }
        }

        public UGraphic apply(UChange uChange) {
            return new Cross(this.getUg().apply(uChange));
        }
    }
}

