/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FtileForkInner
extends AbstractFtile {
    private final List<Ftile> forks = new ArrayList<Ftile>();

    public FtileForkInner(List<Ftile> list) {
        super(list.get(0).shadowing());
        for (Ftile ftile : list) {
            this.forks.add(ftile);
        }
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.forks.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return FtileForkInner.mergeSwimlanes(this.forks);
    }

    public static Set<Swimlane> mergeSwimlanes(List<Ftile> list) {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        for (Ftile ftile : list) {
            hashSet.addAll(ftile.getSwimlanes());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public TextBlock asTextBlock() {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                StringBounder stringBounder = uGraphic.getStringBounder();
                double d = 0.0;
                for (Ftile ftile : FtileForkInner.this.forks) {
                    uGraphic.apply(new UTranslate(d, 0.0)).draw(ftile);
                    Dimension2D dimension2D = ftile.asTextBlock().calculateDimension(stringBounder);
                    d += dimension2D.getWidth();
                }
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return FtileForkInner.this.calculateDimensionInternal(stringBounder);
            }

            @Override
            public List<Url> getUrls() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isKilled() {
        return false;
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        double d = 0.0;
        double d2 = 0.0;
        for (Ftile ftile : this.forks) {
            Dimension2D dimension2D = ftile.asTextBlock().calculateDimension(stringBounder);
            d2 += dimension2D.getWidth();
            if (!(dimension2D.getHeight() > d)) continue;
            d = dimension2D.getHeight();
        }
        return new Dimension2DDouble(d2, d);
    }

    @Override
    public Point2D getPointIn(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        return new Point2D.Double(dimension2D.getWidth() / 2.0, 0.0);
    }

    @Override
    public Point2D getPointOut(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        return new Point2D.Double(dimension2D.getWidth() / 2.0, dimension2D.getHeight());
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        throw new UnsupportedOperationException();
    }
}

