/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMarged;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileGroup
extends AbstractFtile {
    private final double diffYY = 25.0;
    private final Ftile inner;
    private final TextBlock name;
    private final HtmlColor color;

    public FtileGroup(Ftile ftile, Display display, HtmlColor htmlColor) {
        super(ftile.shadowing());
        this.inner = new FtileMarged(ftile, 10.0);
        this.color = htmlColor;
        UFont uFont = new UFont("Serif", 0, 14);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        this.name = display == null ? TextBlockUtils.empty(0.0, 0.0) : TextBlockUtils.create(display, fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.inner.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.inner.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.inner.getSwimlaneOut();
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dimension2D = this.inner.asTextBlock().calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dimension2D, 0.0, 50.0);
    }

    private UTranslate getTranslate() {
        return new UTranslate(0.0, 25.0);
    }

    @Override
    public Point2D getPointIn(StringBounder stringBounder) {
        return this.getTranslate().getTranslated(this.inner.getPointIn(stringBounder));
    }

    @Override
    public Point2D getPointOut(StringBounder stringBounder) {
        return this.getTranslate().getTranslated(this.inner.getPointOut(stringBounder));
    }

    @Override
    public TextBlock asTextBlock() {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                SymbolContext symbolContext = new SymbolContext(HtmlColorUtils.WHITE, HtmlColorUtils.BLACK).withShadow(FtileGroup.this.shadowing()).withStroke(new UStroke(2.0));
                USymbol.FRAME.asBig(FtileGroup.this.name, TextBlockUtils.empty(0.0, 0.0), dimension2D.getWidth(), dimension2D.getHeight(), symbolContext).drawU(uGraphic);
                uGraphic.apply(FtileGroup.this.getTranslate()).draw(FtileGroup.this.inner);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return FtileGroup.this.calculateDimensionInternal(stringBounder);
            }

            @Override
            public List<Url> getUrls() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isKilled() {
        return false;
    }
}

