/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidth;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FtileIf
extends AbstractFtile {
    private final Ftile tile1;
    private final Ftile tile2;
    private final HtmlColor borderColor;
    private final HtmlColor backColor;
    private final HtmlColor arrowColor;
    private final TextBlock label;
    private final TextBlock label1;
    private final TextBlock label2;

    private FtileIf(Ftile ftile, Ftile ftile2, HtmlColor htmlColor, HtmlColor htmlColor2, Display display, Display display2, Display display3, UFont uFont, HtmlColor htmlColor3) {
        super(ftile.shadowing() || ftile2.shadowing());
        this.borderColor = htmlColor;
        this.backColor = htmlColor2;
        this.tile1 = ftile;
        this.tile2 = ftile2;
        this.arrowColor = htmlColor3;
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        this.label = TextBlockUtils.create(display, fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        this.label1 = TextBlockUtils.create(display2, fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        this.label2 = TextBlockUtils.create(display3, fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        hashSet.addAll(this.tile1.getSwimlanes());
        hashSet.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    static Ftile create(Ftile ftile, Ftile ftile2, HtmlColor htmlColor, HtmlColor htmlColor2, Display display, Display display2, Display display3, UFont uFont, HtmlColor htmlColor3, HtmlColor htmlColor4, HtmlColor htmlColor5) {
        ftile = new FtileMinWidth(ftile, 30.0);
        ftile2 = new FtileMinWidth(ftile2, 30.0);
        FtileIf ftileIf = new FtileIf(ftile, ftile2, htmlColor, htmlColor2, display, display2, display3, uFont, htmlColor3);
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        FtileIf ftileIf2 = ftileIf;
        ftileIf2.getClass();
        arrayList.add(ftileIf2.new ConnectionHorizontalThenVertical(ftile));
        FtileIf ftileIf3 = ftileIf;
        ftileIf3.getClass();
        arrayList.add(ftileIf3.new ConnectionHorizontalThenVertical(ftile2));
        if (!ftile.isKilled() && !ftile2.isKilled()) {
            FtileIf ftileIf4 = ftileIf;
            ftileIf4.getClass();
            arrayList.add(ftileIf4.new ConnectionVerticalThenHorizontal(ftile, htmlColor4));
            FtileIf ftileIf5 = ftileIf;
            ftileIf5.getClass();
            arrayList.add(ftileIf5.new ConnectionVerticalThenHorizontal(ftile2, htmlColor5));
        } else if (!ftile.isKilled() && ftile2.isKilled()) {
            FtileIf ftileIf6 = ftileIf;
            ftileIf6.getClass();
            arrayList.add(ftileIf6.new ConnectionVerticalThenHorizontalDirect(ftile, htmlColor4));
        } else if (ftile.isKilled() && !ftile2.isKilled()) {
            FtileIf ftileIf7 = ftileIf;
            ftileIf7.getClass();
            arrayList.add(ftileIf7.new ConnectionVerticalThenHorizontalDirect(ftile2, htmlColor5));
        }
        return FtileUtils.addConnection((Ftile)ftileIf, arrayList);
    }

    private UTranslate getTranslate1(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        Dimension2D dimension2D2 = this.tile1.asTextBlock().calculateDimension(stringBounder);
        double d = (dimension2D.getHeight() - dimension2D2.getHeight()) / 2.0;
        return new UTranslate(0.0, d);
    }

    private UTranslate getTranslate2(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        Dimension2D dimension2D2 = this.tile2.asTextBlock().calculateDimension(stringBounder);
        double d = dimension2D.getWidth() - dimension2D2.getWidth();
        double d2 = (dimension2D.getHeight() - dimension2D2.getHeight()) / 2.0;
        return new UTranslate(d, d2);
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.tile1) {
            return this.getTranslate1(stringBounder);
        }
        if (ftile == this.tile2) {
            return this.getTranslate2(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBlock asTextBlock() {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                StringBounder stringBounder = uGraphic.getStringBounder();
                Dimension2D dimension2D = this.calculateDimension(stringBounder);
                uGraphic.apply(FtileIf.this.getTranslate1(stringBounder)).draw(FtileIf.this.tile1);
                uGraphic.apply(FtileIf.this.getTranslate2(stringBounder)).draw(FtileIf.this.tile2);
                double d = (dimension2D.getWidth() - 24.0) / 2.0;
                FtileIf.this.drawDiamond(uGraphic, d, 0.0);
                if (!FtileIf.this.tile1.isKilled() && !FtileIf.this.tile2.isKilled()) {
                    FtileIf.this.drawDiamond(uGraphic, d, dimension2D.getHeight() - 24.0);
                }
                Dimension2D dimension2D2 = FtileIf.this.label.calculateDimension(stringBounder);
                FtileIf.this.label.drawU(uGraphic.apply(new UTranslate(dimension2D.getWidth() / 2.0 + 5.0, -dimension2D2.getHeight() - 7.0)));
                Dimension2D dimension2D3 = FtileIf.this.label1.calculateDimension(stringBounder);
                FtileIf.this.label1.drawU(uGraphic.apply(new UTranslate(d - dimension2D3.getWidth(), -dimension2D3.getHeight() + 12.0)));
                Dimension2D dimension2D4 = FtileIf.this.label2.calculateDimension(stringBounder);
                FtileIf.this.label2.drawU(uGraphic.apply(new UTranslate(d + 24.0, -dimension2D4.getHeight() + 12.0)));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return FtileIf.this.calculateDimensionInternal(stringBounder);
            }

            @Override
            public List<Url> getUrls() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isKilled() {
        return this.tile1.isKilled() && this.tile2.isKilled();
    }

    private void drawDiamond(UGraphic uGraphic, double d, double d2) {
        uGraphic.apply(new UChangeColor(this.borderColor)).apply(new UStroke(1.5)).apply(new UChangeBackColor(this.backColor)).apply(new UTranslate(d, d2)).draw(Diamond.asPolygon(this.shadowing()));
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dimension2D = Dimension2DDouble.mergeLR(this.tile1.asTextBlock().calculateDimension(stringBounder), this.tile2.asTextBlock().calculateDimension(stringBounder));
        dimension2D = Dimension2DDouble.delta(dimension2D, 25.0, 100.0);
        return dimension2D;
    }

    @Override
    public Point2D getPointIn(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        return new Point2D.Double(dimension2D.getWidth() / 2.0, 0.0);
    }

    @Override
    public Point2D getPointOut(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        return new Point2D.Double(dimension2D.getWidth() / 2.0, dimension2D.getHeight());
    }

    class ConnectionVerticalThenHorizontalDirect
    extends AbstractConnection {
        private final HtmlColor myArrowColor;

        public ConnectionVerticalThenHorizontalDirect(Ftile ftile, HtmlColor htmlColor) {
            super(ftile, null);
            this.myArrowColor = htmlColor == null ? FtileIf.this.arrowColor : htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Dimension2D dimension2D = FtileIf.this.calculateDimensionInternal(stringBounder);
            Point2D point2D = this.getFtile1().getPointOut(stringBounder);
            if (point2D == null) {
                return;
            }
            Point2D point2D2 = this.translate(stringBounder).getTranslated(point2D);
            Point2D.Double double_ = new Point2D.Double(dimension2D.getWidth() / 2.0, dimension2D.getHeight() - 12.0);
            double d = point2D2.getX();
            double d2 = point2D2.getY();
            double d3 = ((Point2D)double_).getX();
            double d4 = ((Point2D)double_).getY();
            Snake snake = new Snake(this.myArrowColor, true);
            snake.addPoint(d, d2);
            snake.addPoint(d, d4);
            snake.addPoint(d3, d4);
            snake.addPoint(d3, dimension2D.getHeight());
            snake.drawU(uGraphic);
        }

        private UTranslate translate(StringBounder stringBounder) {
            if (this.getFtile1() == FtileIf.this.tile1) {
                return FtileIf.this.getTranslate1(stringBounder);
            }
            if (this.getFtile1() == FtileIf.this.tile2) {
                return FtileIf.this.getTranslate2(stringBounder);
            }
            throw new IllegalStateException();
        }
    }

    class ConnectionVerticalThenHorizontal
    extends AbstractConnection {
        private final HtmlColor myArrowColor;

        public ConnectionVerticalThenHorizontal(Ftile ftile, HtmlColor htmlColor) {
            super(ftile, null);
            this.myArrowColor = htmlColor == null ? FtileIf.this.arrowColor : htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Dimension2D dimension2D = FtileIf.this.calculateDimensionInternal(stringBounder);
            Point2D point2D = this.getFtile1().getPointOut(stringBounder);
            if (point2D == null) {
                return;
            }
            Point2D point2D2 = this.translate(stringBounder).getTranslated(point2D);
            Point2D.Double double_ = new Point2D.Double(dimension2D.getWidth() / 2.0 + this.getDX(), dimension2D.getHeight() - 12.0);
            double d = point2D2.getX();
            double d2 = point2D2.getY();
            double d3 = ((Point2D)double_).getX();
            double d4 = ((Point2D)double_).getY();
            UPolygon uPolygon = d3 > d ? Arrows.asToRight() : Arrows.asToLeft();
            Snake snake = new Snake(this.myArrowColor, uPolygon);
            snake.addPoint(d, d2);
            snake.addPoint(d, d4);
            snake.addPoint(d3, d4);
            snake.drawU(uGraphic);
        }

        private double getDX() {
            if (this.getFtile1() == FtileIf.this.tile1) {
                return -12.0;
            }
            if (this.getFtile1() == FtileIf.this.tile2) {
                return 12.0;
            }
            throw new IllegalStateException();
        }

        private UTranslate translate(StringBounder stringBounder) {
            if (this.getFtile1() == FtileIf.this.tile1) {
                return FtileIf.this.getTranslate1(stringBounder);
            }
            if (this.getFtile1() == FtileIf.this.tile2) {
                return FtileIf.this.getTranslate2(stringBounder);
            }
            throw new IllegalStateException();
        }
    }

    class ConnectionHorizontalThenVertical
    extends AbstractConnection {
        public ConnectionHorizontalThenVertical(Ftile ftile) {
            super(null, ftile);
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Dimension2D dimension2D = FtileIf.this.calculateDimensionInternal(stringBounder);
            Point2D.Double double_ = new Point2D.Double(dimension2D.getWidth() / 2.0 + this.getDX(), 12.0);
            Point2D point2D = this.translate(stringBounder).getTranslated(this.getFtile2().getPointIn(stringBounder));
            double d = ((Point2D)double_).getX();
            double d2 = ((Point2D)double_).getY();
            double d3 = point2D.getX();
            double d4 = point2D.getY();
            LinkRendering linkRendering = this.getFtile2().getInLinkRendering();
            Snake snake = new Snake(linkRendering == null ? FtileIf.this.arrowColor : linkRendering.getColor(), Arrows.asToDown());
            snake.addPoint(d, d2);
            snake.addPoint(d3, d2);
            snake.addPoint(d3, d4);
            snake.drawU(uGraphic);
        }

        private double getDX() {
            if (this.getFtile2() == FtileIf.this.tile1) {
                return -12.0;
            }
            if (this.getFtile2() == FtileIf.this.tile2) {
                return 12.0;
            }
            throw new IllegalStateException();
        }

        private UTranslate translate(StringBounder stringBounder) {
            if (this.getFtile2() == FtileIf.this.tile1) {
                return FtileIf.this.getTranslate1(stringBounder);
            }
            if (this.getFtile2() == FtileIf.this.tile2) {
                return FtileIf.this.getTranslate2(stringBounder);
            }
            throw new IllegalStateException();
        }
    }
}

