/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FtileRepeat
extends AbstractFtile {
    private final Ftile repeat;
    private final TextBlock test;
    private final HtmlColor borderColor;
    private final HtmlColor backColor;

    private FtileRepeat(Ftile ftile, Display display, HtmlColor htmlColor, HtmlColor htmlColor2, UFont uFont) {
        super(ftile.shadowing());
        this.repeat = ftile;
        this.borderColor = htmlColor;
        this.backColor = htmlColor2;
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        this.test = TextBlockUtils.create(display, fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.repeat.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.repeat.getSwimlanes();
    }

    public static Ftile create(Ftile ftile, Display display, HtmlColor htmlColor, HtmlColor htmlColor2, UFont uFont, HtmlColor htmlColor3, HtmlColor htmlColor4) {
        FtileRepeat ftileRepeat = new FtileRepeat(ftile, display, htmlColor, htmlColor2, uFont);
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        FtileRepeat ftileRepeat2 = ftileRepeat;
        ftileRepeat2.getClass();
        arrayList.add(ftileRepeat2.new ConnectionIn(LinkRendering.getColor(ftile.getInLinkRendering(), htmlColor3)));
        FtileRepeat ftileRepeat3 = ftileRepeat;
        ftileRepeat3.getClass();
        arrayList.add(ftileRepeat3.new ConnectionBack(htmlColor3));
        FtileRepeat ftileRepeat4 = ftileRepeat;
        ftileRepeat4.getClass();
        arrayList.add(ftileRepeat4.new ConnectionOut(LinkRendering.getColor(htmlColor4, htmlColor3)));
        return FtileUtils.addConnection((Ftile)ftileRepeat, arrayList);
    }

    @Override
    public TextBlock asTextBlock() {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                StringBounder stringBounder = uGraphic.getStringBounder();
                Dimension2D dimension2D = this.calculateDimension(stringBounder);
                uGraphic.apply(FtileRepeat.this.getTranslate(stringBounder)).draw(FtileRepeat.this.repeat);
                double d = (dimension2D.getWidth() - 24.0) / 2.0;
                FtileRepeat.this.drawDiamond(uGraphic, d, 0.0);
                FtileRepeat.this.drawDiamond(uGraphic, d, dimension2D.getHeight() - 24.0);
                Dimension2D dimension2D2 = FtileRepeat.this.test.calculateDimension(stringBounder);
                FtileRepeat.this.test.drawU(uGraphic.apply(new UTranslate(dimension2D.getWidth() / 2.0 + 12.0, dimension2D.getHeight() - 12.0 - dimension2D2.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return FtileRepeat.this.calculateDimensionInternal(stringBounder);
            }

            @Override
            public List<Url> getUrls() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isKilled() {
        return false;
    }

    private void drawDiamond(UGraphic uGraphic, double d, double d2) {
        uGraphic.apply(new UChangeColor(this.borderColor)).apply(new UStroke(1.5)).apply(new UChangeBackColor(this.backColor)).apply(new UTranslate(d, d2)).draw(Diamond.asPolygon(this.shadowing()));
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dimension2D = this.repeat.asTextBlock().calculateDimension(stringBounder);
        dimension2D = Dimension2DDouble.delta(dimension2D, 2.0 * this.getDeltaX(stringBounder), 96.0);
        return dimension2D;
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        return new UTranslate(this.getDeltaX(stringBounder), 48.0);
    }

    private double getDeltaX(StringBounder stringBounder) {
        double d = this.test.calculateDimension(stringBounder).getWidth();
        if (d < 24.0) {
            return 24.0;
        }
        return d + 12.0;
    }

    @Override
    public Point2D getPointIn(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        return new Point2D.Double(dimension2D.getWidth() / 2.0, 0.0);
    }

    @Override
    public Point2D getPointOut(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        return new Point2D.Double(dimension2D.getWidth() / 2.0, dimension2D.getHeight());
    }

    class ConnectionOut
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionOut(HtmlColor htmlColor) {
            super(null, null);
            this.arrowColor = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            UTranslate uTranslate = FtileRepeat.this.getTranslate(stringBounder);
            Point2D point2D = uTranslate.getTranslated(FtileRepeat.this.repeat.getPointOut(stringBounder));
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            Dimension2D dimension2D = FtileRepeat.this.calculateDimensionInternal(stringBounder);
            snake.addPoint(point2D.getX(), point2D.getY());
            snake.addPoint(dimension2D.getWidth() / 2.0, dimension2D.getHeight() - 24.0);
            snake.drawU(uGraphic);
        }
    }

    class ConnectionBack
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionBack(HtmlColor htmlColor) {
            super(null, null);
            this.arrowColor = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowColor, Arrows.asToLeft());
            Dimension2D dimension2D = FtileRepeat.this.calculateDimensionInternal(stringBounder);
            snake.addPoint(dimension2D.getWidth() / 2.0 + 12.0, dimension2D.getHeight() - 12.0);
            snake.addPoint(dimension2D.getWidth() - 12.0, dimension2D.getHeight() - 12.0);
            snake.addPoint(dimension2D.getWidth() - 12.0, 12.0);
            snake.addPoint(dimension2D.getWidth() / 2.0 + 12.0, 12.0);
            uGraphic = uGraphic.apply(new UChangeColor(this.arrowColor)).apply(new UChangeBackColor(this.arrowColor));
            uGraphic.apply(new UTranslate(dimension2D.getWidth() - 12.0, dimension2D.getHeight() / 2.0)).draw(Arrows.asToUp());
            snake.drawU(uGraphic.apply(new UStroke(1.5)));
        }
    }

    class ConnectionIn
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionIn(HtmlColor htmlColor) {
            super(null, null);
            this.arrowColor = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            UTranslate uTranslate = FtileRepeat.this.getTranslate(stringBounder);
            Point2D point2D = uTranslate.getTranslated(FtileRepeat.this.repeat.getPointIn(stringBounder));
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            Dimension2D dimension2D = FtileRepeat.this.calculateDimensionInternal(stringBounder);
            snake.addPoint(dimension2D.getWidth() / 2.0, 24.0);
            snake.addPoint(point2D.getX(), point2D.getY());
            snake.drawU(uGraphic);
        }
    }
}

