/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FtileWhile
extends AbstractFtile {
    private final Ftile whileBlock;
    private final TextBlock test;
    private final TextBlock out;
    private final HtmlColor borderColor;
    private final HtmlColor backColor;
    private final HtmlColor arrowColor;
    private final HtmlColor endInlinkColor;

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.whileBlock.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.whileBlock.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    private FtileWhile(Ftile ftile, Display display, HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, Display display2, Display display3, UFont uFont, HtmlColor htmlColor4) {
        super(ftile.shadowing());
        this.arrowColor = htmlColor3;
        this.whileBlock = ftile;
        this.borderColor = htmlColor;
        this.backColor = htmlColor2;
        this.endInlinkColor = htmlColor4;
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        TextBlock textBlock = TextBlockUtils.create(display2, fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        this.test = display == null ? textBlock : TextBlockUtils.mergeTB(TextBlockUtils.create(display, fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty()), textBlock, HorizontalAlignment.CENTER);
        this.out = TextBlockUtils.create(display3, fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    public static Ftile create(Ftile ftile, Display display, HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, Display display2, Display display3, UFont uFont, HtmlColor htmlColor4, LinkRendering linkRendering) {
        FtileWhile ftileWhile = new FtileWhile(ftile, display, htmlColor, htmlColor2, htmlColor3, display2, display3, uFont, htmlColor4);
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        arrayList.add(ftileWhile.new ConnectionIn());
        arrayList.add(ftileWhile.new ConnectionBack());
        HtmlColor htmlColor5 = htmlColor3;
        if (linkRendering != null && linkRendering.getColor() != null) {
            htmlColor5 = linkRendering.getColor();
        }
        FtileWhile ftileWhile2 = ftileWhile;
        ftileWhile2.getClass();
        arrayList.add(ftileWhile2.new ConnectionOut(htmlColor5));
        return FtileUtils.addConnection((Ftile)ftileWhile, arrayList);
    }

    @Override
    public TextBlock asTextBlock() {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                StringBounder stringBounder = uGraphic.getStringBounder();
                Dimension2D dimension2D = this.calculateDimension(stringBounder);
                uGraphic.apply(FtileWhile.this.getTranslate(stringBounder)).draw(FtileWhile.this.whileBlock);
                double d = (dimension2D.getWidth() - 24.0) / 2.0;
                FtileWhile.this.drawDiamond(uGraphic, d, 0.0);
                Dimension2D dimension2D2 = FtileWhile.this.test.calculateDimension(stringBounder);
                FtileWhile.this.test.drawU(uGraphic.apply(new UTranslate((dimension2D.getWidth() - dimension2D2.getWidth()) / 2.0, 19.0)));
                FtileWhile.this.out.drawU(uGraphic);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return FtileWhile.this.calculateDimensionInternal(stringBounder);
            }

            @Override
            public List<Url> getUrls() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void drawDiamond(UGraphic uGraphic, double d, double d2) {
        uGraphic.apply(new UChangeColor(this.borderColor)).apply(new UStroke(1.5)).apply(new UChangeBackColor(this.backColor)).apply(new UTranslate(d, d2)).draw(Diamond.asPolygon(this.shadowing()));
    }

    @Override
    public boolean isKilled() {
        return false;
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dimension2D = this.whileBlock.asTextBlock().calculateDimension(stringBounder);
        dimension2D = Dimension2DDouble.delta(dimension2D, 2.0 * this.getDeltaX(stringBounder), this.getDeltaY(stringBounder) + 48.0);
        return dimension2D;
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        return new UTranslate(this.getDeltaX(stringBounder), this.getDeltaY(stringBounder));
    }

    private double getDeltaY(StringBounder stringBounder) {
        double d = this.test.calculateDimension(stringBounder).getHeight();
        return d + 48.0;
    }

    private double getDeltaX(StringBounder stringBounder) {
        double d = this.whileBlock.asTextBlock().calculateDimension(stringBounder).getWidth();
        double d2 = this.out.calculateDimension(stringBounder).getWidth();
        double d3 = d2 - d / 2.0;
        if (d3 < 12.0) {
            return 24.0;
        }
        return d3 + 12.0;
    }

    @Override
    public Point2D getPointIn(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        return new Point2D.Double(dimension2D.getWidth() / 2.0, 0.0);
    }

    @Override
    public Point2D getPointOut(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        return new Point2D.Double(dimension2D.getWidth() / 2.0, dimension2D.getHeight());
    }

    class ConnectionOut
    extends AbstractConnection {
        private final HtmlColor afterEndwhileColor;

        public ConnectionOut(HtmlColor htmlColor) {
            super(null, null);
            this.afterEndwhileColor = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.afterEndwhileColor);
            Dimension2D dimension2D = FtileWhile.this.calculateDimensionInternal(stringBounder);
            snake.addPoint(dimension2D.getWidth() / 2.0 - 12.0, 12.0);
            Dimension2D dimension2D2 = FtileWhile.this.whileBlock.asTextBlock().calculateDimension(stringBounder);
            double d = dimension2D.getWidth() / 2.0 - dimension2D2.getWidth() / 2.0 - 12.0;
            snake.addPoint(d, 12.0);
            snake.addPoint(d, dimension2D.getHeight());
            snake.addPoint(dimension2D.getWidth() / 2.0, dimension2D.getHeight());
            uGraphic = uGraphic.apply(new UChangeColor(this.afterEndwhileColor)).apply(new UChangeBackColor(this.afterEndwhileColor));
            uGraphic.apply(new UTranslate(d, dimension2D.getHeight() / 2.0)).draw(Arrows.asToDown());
            snake.drawU(uGraphic);
        }
    }

    class ConnectionBack
    extends AbstractConnection {
        public ConnectionBack() {
            super(null, null);
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            UTranslate uTranslate = FtileWhile.this.getTranslate(stringBounder);
            Point2D point2D = uTranslate.getTranslated(FtileWhile.this.whileBlock.getPointOut(stringBounder));
            Snake snake = new Snake(FtileWhile.this.endInlinkColor, Arrows.asToLeft());
            Dimension2D dimension2D = FtileWhile.this.calculateDimensionInternal(stringBounder);
            Dimension2D dimension2D2 = FtileWhile.this.whileBlock.asTextBlock().calculateDimension(stringBounder);
            snake.addPoint(point2D.getX(), point2D.getY());
            snake.addPoint(point2D.getX(), point2D.getY() + 12.0);
            double d = dimension2D.getWidth() / 2.0 + dimension2D2.getWidth() / 2.0 + 12.0;
            snake.addPoint(d, point2D.getY() + 12.0);
            snake.addPoint(d, 12.0);
            snake.addPoint(dimension2D.getWidth() / 2.0 + 12.0, 12.0);
            uGraphic = uGraphic.apply(new UChangeColor(FtileWhile.this.endInlinkColor)).apply(new UChangeBackColor(FtileWhile.this.endInlinkColor));
            uGraphic.apply(new UTranslate(d, dimension2D.getHeight() / 2.0)).draw(Arrows.asToUp());
            snake.drawU(uGraphic);
            uGraphic.apply(new UTranslate(dimension2D.getWidth() / 2.0, point2D.getY() + 12.0)).draw(new UEmpty(5.0, 15.0));
        }
    }

    class ConnectionIn
    extends AbstractConnection {
        public ConnectionIn() {
            super(null, null);
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            UTranslate uTranslate = FtileWhile.this.getTranslate(stringBounder);
            HtmlColor htmlColor = LinkRendering.getColor(FtileWhile.this.whileBlock.getInLinkRendering(), FtileWhile.this.arrowColor);
            Point2D point2D = uTranslate.getTranslated(FtileWhile.this.whileBlock.getPointIn(stringBounder));
            Snake snake = new Snake(htmlColor, Arrows.asToDown());
            Dimension2D dimension2D = FtileWhile.this.calculateDimensionInternal(stringBounder);
            snake.addPoint(dimension2D.getWidth() / 2.0, 24.0);
            snake.addPoint(point2D.getX(), point2D.getY());
            snake.drawU(uGraphic);
        }
    }
}

