/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileBox
extends AbstractFtile {
    private static final int CORNER = 25;
    private static final int MARGIN = 10;
    private final TextBlock tb;
    private final HtmlColor color;
    private final HtmlColor backColor;
    private final LinkRendering inRenreding;
    private final Swimlane swimlane;
    private final String print;

    @Override
    public final LinkRendering getInLinkRendering() {
        return this.inRenreding;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    public FtileBox(boolean bl, Display display, HtmlColor htmlColor, HtmlColor htmlColor2, UFont uFont, HtmlColor htmlColor3, Swimlane swimlane) {
        super(bl);
        this.color = htmlColor;
        this.swimlane = swimlane;
        this.backColor = htmlColor2;
        this.inRenreding = new LinkRendering(htmlColor3);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        this.tb = TextBlockUtils.create(display, fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        this.print = display.toString();
    }

    public String toString() {
        return this.print;
    }

    @Override
    public TextBlock asTextBlock() {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                double d = dimension2D.getWidth();
                double d2 = dimension2D.getHeight();
                URectangle uRectangle = new URectangle(d, d2, 25.0, 25.0);
                if (FtileBox.this.shadowing()) {
                    uRectangle.setDeltaShadow(3.0);
                }
                uGraphic.apply(new UChangeColor(FtileBox.this.color)).apply(new UChangeBackColor(FtileBox.this.backColor)).apply(new UStroke(1.5)).draw(uRectangle);
                FtileBox.this.tb.drawU(uGraphic.apply(new UTranslate(10.0, 10.0)));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = FtileBox.this.tb.calculateDimension(stringBounder);
                return Dimension2DDouble.delta(dimension2D, 20.0, 20.0);
            }

            @Override
            public List<Url> getUrls() {
                return FtileBox.this.tb.getUrls();
            }
        };
    }

    @Override
    public boolean isKilled() {
        return false;
    }

    @Override
    public Point2D getPointIn(StringBounder stringBounder) {
        Dimension2D dimension2D = this.tb.calculateDimension(stringBounder);
        return new Point2D.Double(dimension2D.getWidth() / 2.0 + 10.0, 0.0);
    }

    @Override
    public Point2D getPointOut(StringBounder stringBounder) {
        Dimension2D dimension2D = this.tb.calculateDimension(stringBounder);
        return new Point2D.Double(dimension2D.getWidth() / 2.0 + 10.0, dimension2D.getHeight() + 20.0);
    }
}

