/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.GenericRegexProducer;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkStyle;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateClassMultilines
extends CommandMultilines2<ClassDiagram> {
    public CommandCreateClassMultilines() {
        super(CommandCreateClassMultilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^\\s*\\}\\s*$";
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(interface|enum|abstract\\s+class|abstract|class)\\s+"), new RegexOr(new RegexConcat(new RegexLeaf("DISPLAY1", "\"([^\"]+)\""), new RegexLeaf("\\s+as\\s+"), new RegexLeaf("CODE1", "([^\\s{}\"<>]+)")), new RegexConcat(new RegexLeaf("CODE2", "([^\\s{}\"<>]+)"), new RegexLeaf("\\s+as\\s+"), new RegexLeaf("DISPLAY2", "\"([^\"]+)\"")), new RegexLeaf("CODE3", "([^\\s{}\"<>]+)"), new RegexLeaf("CODE4", "\"([^\"]+)\"")), new RegexLeaf("GENERIC", "(?:\\s*\\<(" + GenericRegexProducer.PATTERN + ")\\>)?"), new RegexLeaf("STEREO", "(?:\\s*(\\<\\<.+\\>\\>))?"), new RegexLeaf("\\s*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("\\s*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("\\s*"), new RegexLeaf("LINECOLOR", "(?:##(?:\\[(dotted|dashed|bold)\\])?(\\w+)?)?"), new RegexLeaf("EXTENDS", "(\\s+(extends|implements)\\s+((?:\\.|::)?[\\p{L}0-9_]+(?:(?:\\.|::)[\\p{L}0-9_]+)*))?"), new RegexLeaf("\\s*\\{\\s*$"));
    }

    @Override
    public CommandExecutionResult executeNow(ClassDiagram classDiagram, List<String> list) {
        Url url;
        StringUtils.trim(list, false);
        RegexResult regexResult = this.getStartingPattern().matcher(list.get(0).trim());
        IEntity iEntity = this.executeArg0(classDiagram, regexResult);
        if (iEntity == null) {
            return CommandExecutionResult.error("No such entity");
        }
        if ((list = list.subList(1, list.size() - 1)).size() > 0) {
            UrlBuilder urlBuilder = new UrlBuilder(classDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            url = urlBuilder.getUrl(list.get(0).toString());
        } else {
            url = null;
        }
        if (url != null) {
            list = list.subList(1, list.size());
        }
        for (String string : list) {
            if (string.length() > 0 && VisibilityModifier.isVisibilityCharacter(string.charAt(0))) {
                classDiagram.setVisibilityModifierPresent(true);
            }
            iEntity.addFieldOrMethod(string);
        }
        if (url != null) {
            iEntity.addUrl(url);
        }
        CommandCreateClassMultilines.manageExtends(classDiagram, regexResult, iEntity);
        return CommandExecutionResult.ok();
    }

    private static void manageExtends(ClassDiagram classDiagram, RegexResult regexResult, IEntity iEntity) {
        if (regexResult.get("EXTENDS", 1) != null) {
            Mode mode = regexResult.get("EXTENDS", 1).equalsIgnoreCase("extends") ? Mode.EXTENDS : Mode.IMPLEMENTS;
            Code code = Code.of(regexResult.get("EXTENDS", 2));
            LeafType leafType = LeafType.CLASS;
            if (mode == Mode.IMPLEMENTS) {
                leafType = LeafType.INTERFACE;
            }
            if (mode == Mode.EXTENDS && iEntity.getEntityType() == LeafType.INTERFACE) {
                leafType = LeafType.INTERFACE;
            }
            ILeaf iLeaf = classDiagram.getOrCreateLeaf1(code, leafType);
            LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.EXTENDS);
            if (leafType == LeafType.INTERFACE && iEntity.getEntityType() != LeafType.INTERFACE) {
                linkType = linkType.getDashed();
            }
            Link link = new Link(iLeaf, iEntity, linkType, null, 2, null, null, classDiagram.getLabeldistance(), classDiagram.getLabelangle());
            classDiagram.addLink(link);
        }
    }

    private IEntity executeArg0(ClassDiagram classDiagram, RegexResult regexResult) {
        String string;
        ILeaf iLeaf;
        LeafType leafType = LeafType.getLeafType(regexResult.get("TYPE", 0).toUpperCase());
        Code code = Code.of(regexResult.getLazzy("CODE", 0)).eventuallyRemoveStartingAndEndingDoubleQuote();
        String string2 = regexResult.getLazzy("DISPLAY", 0);
        String string3 = regexResult.get("STEREO", 0);
        String string4 = regexResult.get("GENERIC", 0);
        if (classDiagram.leafExist(code)) {
            iLeaf = classDiagram.getOrCreateLeaf1(code, null);
            iLeaf.muteToType(leafType);
        } else {
            iLeaf = classDiagram.createLeaf(code, Display.getWithNewlines(string2), leafType);
        }
        if (string3 != null) {
            iLeaf.setStereotype(new Stereotype(string3, classDiagram.getSkinParam().getCircledCharacterRadius(), classDiagram.getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        if ((string = regexResult.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(classDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(string);
            iLeaf.addUrl(url);
        }
        iLeaf.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("COLOR", 0)));
        iLeaf.setSpecificLineColor(HtmlColorUtils.getColorIfValid(regexResult.get("LINECOLOR", 1)));
        this.applyStroke(iLeaf, regexResult.get("LINECOLOR", 0));
        if (string4 != null) {
            iLeaf.setGeneric(string4);
        }
        return iLeaf;
    }

    public UStroke getStroke(LinkStyle linkStyle) {
        if (linkStyle == LinkStyle.DASHED) {
            return new UStroke(6.0, 6.0, 1.0);
        }
        if (linkStyle == LinkStyle.DOTTED) {
            return new UStroke(1.0, 3.0, 1.0);
        }
        if (linkStyle == LinkStyle.BOLD) {
            return new UStroke(2.5);
        }
        return new UStroke();
    }

    private void applyStroke(ILeaf iLeaf, String string) {
        if (string == null) {
            return;
        }
        LinkStyle linkStyle = LinkStyle.valueOf(string.toUpperCase());
        iLeaf.setSpecificLineStroke(this.getStroke(linkStyle));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        EXTENDS,
        IMPLEMENTS;

    }
}

