/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.ugraphic.SpriteImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandSpriteFile
extends SingleLineCommand2<UmlDiagram> {
    public CommandSpriteFile() {
        super(CommandSpriteFile.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("sprite\\s+\\$?"), new RegexLeaf("NAME", "([\\p{L}0-9_]+)\\s*"), new RegexLeaf("\\s+"), new RegexLeaf("FILE", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(UmlDiagram umlDiagram, RegexResult regexResult) {
        BufferedImage bufferedImage;
        String string = regexResult.get("FILE", 0);
        try {
            File file = FileSystem.getInstance().getFile(string);
            if (!file.exists()) {
                return CommandExecutionResult.error("File does not exist: " + string);
            }
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException iOException) {
            Log.error("Error reading " + string + " " + iOException);
            return CommandExecutionResult.error("Cannot read: " + string);
        }
        umlDiagram.addSprite(regexResult.get("NAME", 0), new SpriteImage(bufferedImage));
        return CommandExecutionResult.ok();
    }
}

