/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note.sequence;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactorySequenceNoteOverSeveralCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("STYLE", "^(note|hnote|rnote)\\s+over\\s+"), new RegexLeaf("P1", "([\\p{L}0-9_.@]+|\"[^\"]+\")\\s*\\,\\s*"), new RegexLeaf("P2", "([\\p{L}0-9_.@]+|\"[^\"]+\")\\s*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("STYLE", "^(note|hnote|rnote)\\s+over\\s+"), new RegexLeaf("P1", "([\\p{L}0-9_.@]+|\"[^\"]+\")\\s*\\,\\s*"), new RegexLeaf("P2", "([\\p{L}0-9_.@]+|\"[^\"]+\")\\s*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("\\s*:\\s*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    public Command<SequenceDiagram> createSingleLine() {
        return new SingleLineCommand2<SequenceDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, RegexResult regexResult) {
                List<String> list = StringUtils.getWithNewlines2(regexResult.get("NOTE", 0));
                return FactorySequenceNoteOverSeveralCommand.this.executeInternal(sequenceDiagram, regexResult, list);
            }
        };
    }

    @Override
    public Command<SequenceDiagram> createMultiLine() {
        return new CommandMultilines2<SequenceDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^end ?(note|hnote|rnote)$";
            }

            @Override
            public CommandExecutionResult executeNow(SequenceDiagram sequenceDiagram, List<String> list) {
                RegexResult regexResult = this.getStartingPattern().matcher(list.get(0).trim());
                List<String> list2 = StringUtils.removeEmptyColumns(list.subList(1, list.size() - 1));
                return FactorySequenceNoteOverSeveralCommand.this.executeInternal(sequenceDiagram, regexResult, list2);
            }
        };
    }

    private CommandExecutionResult executeInternal(SequenceDiagram sequenceDiagram, RegexResult regexResult, List<String> list) {
        Participant participant = sequenceDiagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("P1", 0)));
        Participant participant2 = sequenceDiagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("P2", 0)));
        if (list.size() > 0) {
            Note note = new Note(participant, participant2, new Display(list));
            note.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("COLOR", 0)));
            note.setStyle(NoteStyle.getNoteStyle(regexResult.get("STYLE", 0)));
            sequenceDiagram.addNote(note, false);
        }
        return CommandExecutionResult.ok();
    }
}

