/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.svek.GroupPngMakerState;
import net.sourceforge.plantuml.svek.IEntityImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramSimplifierState {
    private final CucaDiagram diagram;

    public CucaDiagramSimplifierState(CucaDiagram cucaDiagram, List<String> list) throws IOException, InterruptedException {
        boolean bl;
        this.diagram = cucaDiagram;
        do {
            bl = false;
            Collection<IGroup> collection = this.putConcurrentStateAtEnd(cucaDiagram.getGroups(false));
            for (IGroup iGroup : collection) {
                if (!cucaDiagram.isAutarkic(iGroup)) continue;
                IEntityImage iEntityImage = this.computeImage(iGroup);
                ArrayList<Url> arrayList = new ArrayList<Url>(iGroup.getUrls());
                for (ILeaf iLeaf : iGroup.getLeafsDirect()) {
                    arrayList.addAll(iLeaf.getUrls());
                }
                iGroup.overideImage(iEntityImage, arrayList, iGroup.zgetGroupType() == GroupType.CONCURRENT_STATE ? LeafType.STATE_CONCURRENT : LeafType.STATE);
                bl = true;
            }
        } while (bl);
    }

    private Collection<IGroup> putConcurrentStateAtEnd(Collection<IGroup> collection) {
        ArrayList<IGroup> arrayList = new ArrayList<IGroup>();
        ArrayList<IGroup> arrayList2 = new ArrayList<IGroup>();
        for (IGroup iGroup : collection) {
            if (iGroup.zgetGroupType() == GroupType.CONCURRENT_STATE) {
                arrayList2.add(iGroup);
                continue;
            }
            arrayList.add(iGroup);
        }
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    private IEntityImage computeImage(IGroup iGroup) throws IOException, InterruptedException {
        GroupPngMakerState groupPngMakerState = new GroupPngMakerState(this.diagram, iGroup);
        return groupPngMakerState.getImage();
    }
}

