/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.graphic.USymbol;

public class DescriptionDiagram
extends AbstractEntityDiagram {
    public ILeaf getOrCreateLeaf1(Code code, LeafType leafType) {
        if (leafType == null) {
            String string = code.getCode();
            if (string.startsWith("[") && string.endsWith("]")) {
                return this.getOrCreateLeaf1Default(code.eventuallyRemoveStartingAndEndingDoubleQuote(), LeafType.COMPONENT);
            }
            if (string.startsWith(":") && string.endsWith(":")) {
                return this.getOrCreateLeaf1Default(code.eventuallyRemoveStartingAndEndingDoubleQuote(), LeafType.ACTOR);
            }
            if (string.startsWith("()")) {
                string = string.substring(2).trim();
                string = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string);
                return this.getOrCreateLeaf1Default(Code.of(string), LeafType.CIRCLE_INTERFACE);
            }
            code = code.eventuallyRemoveStartingAndEndingDoubleQuote();
            return this.getOrCreateLeaf1Default(code, LeafType.STILL_UNKNOWN);
        }
        return this.getOrCreateLeaf1Default(code, leafType);
    }

    private boolean isUsecase() {
        for (ILeaf iLeaf : this.getLeafs().values()) {
            LeafType leafType = iLeaf.getEntityType();
            USymbol uSymbol = iLeaf.getUSymbol();
            if (leafType != LeafType.USECASE && uSymbol != USymbol.ACTOR) continue;
            return true;
        }
        return false;
    }

    public void makeDiagramReady() {
        LeafType leafType = this.isUsecase() ? LeafType.ACTOR : LeafType.CIRCLE_INTERFACE;
        for (ILeaf iLeaf : this.getLeafs().values()) {
            if (iLeaf.getEntityType() != LeafType.STILL_UNKNOWN) continue;
            iLeaf.muteToType(leafType);
        }
    }

    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.DESCRIPTION;
    }
}

