/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.USymbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateElementMultilines
extends CommandMultilines2<DescriptionDiagram> {
    public CommandCreateElementMultilines() {
        super(CommandCreateElementMultilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^(.*)\"$";
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(usecase|database)\\s+"), new RegexLeaf("CODE", "([\\p{L}0-9_.]+)"), new RegexLeaf("STEREO", "(?:\\s*(\\<\\<.+\\>\\>))?"), new RegexLeaf("\\s*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("\\s*"), new RegexLeaf("DESC", "as\\s*\"(.*)$"));
    }

    @Override
    public CommandExecutionResult executeNow(DescriptionDiagram descriptionDiagram, List<String> list) {
        List<String> list2;
        USymbol uSymbol;
        LeafType leafType;
        StringUtils.trim(list, false);
        RegexResult regexResult = this.getStartingPattern().matcher(list.get(0).trim());
        String string = regexResult.get("TYPE", 0).toUpperCase();
        if (string.equalsIgnoreCase("usecase")) {
            leafType = LeafType.USECASE;
            uSymbol = null;
        } else if (string.equalsIgnoreCase("database")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.DATABASE;
        } else {
            throw new IllegalStateException();
        }
        Code code = Code.of(regexResult.get("CODE", 0));
        Display display = new Display(list.subList(1, list.size() - 1));
        String string2 = regexResult.get("DESC", 0);
        if (StringUtils.isNotEmpty(string2)) {
            display = display.addFirst(string2);
        }
        if (StringUtils.isNotEmpty((list2 = StringUtils.getSplit(Pattern.compile(this.getPatternEnd()), list.get(list.size() - 1))).get(0))) {
            display = display.add(list2.get(0));
        }
        String string3 = regexResult.get("STEREO", 0);
        ILeaf iLeaf = descriptionDiagram.createLeaf(code, display, leafType);
        iLeaf.setUSymbol(uSymbol);
        if (string3 != null) {
            iLeaf.setStereotype(new Stereotype(string3, descriptionDiagram.getSkinParam().getCircledCharacterRadius(), descriptionDiagram.getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        iLeaf.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("COLOR", 0)));
        return CommandExecutionResult.ok();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        EXTENDS,
        IMPLEMENTS;

    }
}

