/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ftp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpConnexion {
    private final String user;
    private final Map<String, String> incoming = new HashMap<String, String>();
    private final Map<String, byte[]> outgoing = new HashMap<String, byte[]>();

    public FtpConnexion(String string) {
        this.user = string;
    }

    public synchronized void addIncoming(String string, String string2) {
        if (string.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        this.incoming.put(string, string2);
    }

    public void removeOutgoing(String string) {
        this.outgoing.remove(string);
    }

    public synchronized Collection<String> getFiles() {
        ArrayList<String> arrayList = new ArrayList<String>(this.incoming.keySet());
        arrayList.addAll(this.outgoing.keySet());
        return Collections.unmodifiableCollection(arrayList);
    }

    public synchronized byte[] getData(String string) {
        if (string.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        String string2 = this.incoming.get(string);
        if (string2 != null) {
            return string2.getBytes();
        }
        byte[] byArray = this.outgoing.get(string);
        if (byArray != null) {
            return byArray;
        }
        return new byte[0];
    }

    public synchronized int getSize(String string) {
        if (string.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        String string2 = this.incoming.get(string);
        if (string2 != null) {
            return string2.length();
        }
        byte[] byArray = this.outgoing.get(string);
        if (byArray != null) {
            return byArray.length;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processImage(String string) throws IOException {
        if (string.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        SourceStringReader sourceStringReader = new SourceStringReader(this.incoming.get(string));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileFormat fileFormat = FileFormat.PNG;
        String string2 = sourceStringReader.generateImage((OutputStream)byteArrayOutputStream, new FileFormatOption(fileFormat));
        String string3 = fileFormat.changeName(string, 0);
        String string4 = string3.substring(0, string3.length() - 4) + ".err";
        this.outgoing.remove(string3);
        this.outgoing.remove(string4);
        if (string2 != null) {
            FtpConnexion ftpConnexion = this;
            synchronized (ftpConnexion) {
                this.outgoing.put(string3, byteArrayOutputStream.toByteArray());
                if (string2.startsWith("(Error)")) {
                    ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                    sourceStringReader.generateImage((OutputStream)byteArrayOutputStream2, new FileFormatOption(FileFormat.ATXT));
                    byteArrayOutputStream2.close();
                    this.outgoing.put(string4, byteArrayOutputStream2.toByteArray());
                }
            }
        }
    }

    public synchronized void delete(String string) {
        this.incoming.remove(string);
        this.outgoing.remove(string);
    }
}

