/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodsOrFieldsArea {
    private final UFont font;
    private final List<String> strings = new ArrayList<String>();

    public MethodsOrFieldsArea(List<Member> list, UFont uFont) {
        this.font = uFont;
        for (Member member : list) {
            this.strings.add(member.getDisplay(false));
        }
    }

    public VisibilityModifier getVisibilityModifier() {
        throw new UnsupportedOperationException();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = 0.0;
        double d2 = 0.0;
        for (String string : this.strings) {
            TextBlock textBlock = this.createTextBlock(string);
            Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
            d2 += dimension2D.getHeight();
            d = Math.max(dimension2D.getWidth(), d);
        }
        return new Dimension2DDouble(d, d2);
    }

    private TextBlock createTextBlock(String string) {
        return TextBlockUtils.create(Display.asList(string), new FontConfiguration(this.font, HtmlColorUtils.BLACK), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    public void draw(UGraphic uGraphic, double d, double d2) {
        for (String string : this.strings) {
            TextBlock textBlock = this.createTextBlock(string);
            textBlock.drawU(uGraphic.apply(new UTranslate(d, d2)));
            d2 += textBlock.calculateDimension(uGraphic.getStringBounder()).getHeight();
        }
    }
}

