/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextBlockBordered
implements TextBlock {
    private final TextBlock textBlock;
    private final HtmlColor color;

    public TextBlockBordered(TextBlock textBlock, HtmlColor htmlColor) {
        this.textBlock = textBlock;
        this.color = htmlColor;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dimension2D, 1.0, 1.0);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(uGraphic.getStringBounder());
        this.textBlock.drawU(uGraphic.apply(new UTranslate(1.0, 1.0)));
        uGraphic.apply(new UChangeColor(this.color)).draw(new URectangle(dimension2D.getWidth(), dimension2D.getHeight()));
    }

    @Override
    public List<Url> getUrls() {
        return this.textBlock.getUrls();
    }
}

