/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.hector.Box2D;
import net.sourceforge.plantuml.hector.Pin;
import net.sourceforge.plantuml.hector.PinFactory;
import net.sourceforge.plantuml.hector.PinLink;
import net.sourceforge.plantuml.hector.Skeleton;
import net.sourceforge.plantuml.hector.SkeletonBuilder;
import net.sourceforge.plantuml.hector.SkeletonConfiguration;
import net.sourceforge.plantuml.hector.SkeletonConfigurationUtils;
import net.sourceforge.plantuml.hector.SmartConnection;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CucaDiagramFileMakerHector4
implements CucaDiagramFileMaker {
    private final CucaDiagram diagram;
    private SkeletonConfiguration configuration;
    private double singleWidth;
    private double singleHeight;
    private double nodeMargin = 40.0;
    private final Map<Pin, IEntityImage> images = new LinkedHashMap<Pin, IEntityImage>();
    private final Map<Pin, Box2D> boxes = new LinkedHashMap<Pin, Box2D>();
    private final Map<Link, PinLink> links = new LinkedHashMap<Link, PinLink>();
    private final List<Box2D> forbidden = new ArrayList<Box2D>();

    public CucaDiagramFileMakerHector4(CucaDiagram cucaDiagram) {
        this.diagram = cucaDiagram;
    }

    private double getX(Pin pin) {
        return this.singleWidth * (double)this.configuration.getCol(pin);
    }

    private double getY(Pin pin) {
        return this.singleHeight * (double)pin.getRow();
    }

    private double getCenterX(Pin pin) {
        return this.singleWidth * (double)this.configuration.getCol(pin) + this.singleWidth / 2.0;
    }

    private double getCenterY(Pin pin) {
        return this.singleHeight * (double)pin.getRow() + this.singleHeight / 2.0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImageData createFile(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException {
        double d;
        double d2;
        Dimension2D dimension2D;
        IEntityImage iEntityImage;
        Pin pin;
        void var7_10;
        Object object;
        Object object2;
        PinFactory pinFactory = new PinFactory();
        SkeletonBuilder skeletonBuilder = new SkeletonBuilder();
        this.links.clear();
        for (Link object32 : this.diagram.getLinks()) {
            PinLink pinLink = pinFactory.createPinLink(object32);
            this.links.put(object32, pinLink);
            skeletonBuilder.add(pinLink);
        }
        Skeleton skeleton = skeletonBuilder.createSkeletons().get(0);
        this.configuration = SkeletonConfigurationUtils.getBest(skeleton);
        this.singleWidth = 0.0;
        this.singleHeight = 0.0;
        this.images.clear();
        for (Pin pin2 : skeleton.getPins()) {
            ILeaf iLeaf = (ILeaf)pin2.getUserData();
            object2 = this.computeImage(iLeaf);
            object = TextBlockUtils.getDimension((TextBlock)object2);
            if (((Dimension2D)object).getWidth() > this.singleWidth) {
                this.singleWidth = ((Dimension2D)object).getWidth();
            }
            if (((Dimension2D)object).getHeight() > this.singleHeight) {
                this.singleHeight = ((Dimension2D)object).getHeight();
            }
            this.images.put(pin2, (IEntityImage)object2);
        }
        this.singleHeight += this.nodeMargin;
        this.singleWidth += this.nodeMargin;
        MinMax minMax = MinMax.getEmpty(false);
        for (Pin pin3 : skeleton.getPins()) {
            MinMax minMax3 = var7_10.addPoint(this.getX(pin3), this.getY(pin3));
            minMax3 = minMax3.addPoint(this.getX(pin3) + this.singleWidth, this.getY(pin3) + this.singleHeight);
        }
        object2 = new Dimension2DDouble(20.0 + var7_10.getMaxX(), 20.0 + var7_10.getMaxY());
        object = fileFormatOption.createUGraphic(this.diagram.getColorMapper(), this.diagram.getDpiFactor(fileFormatOption), (Dimension2D)object2, null, false);
        object = object.apply(new UTranslate(10.0, 10.0));
        this.forbidden.clear();
        for (Map.Entry<Pin, IEntityImage> entry : this.images.entrySet()) {
            pin = entry.getKey();
            iEntityImage = entry.getValue();
            dimension2D = iEntityImage.calculateDimension(object.getStringBounder());
            d2 = this.getX(pin) + (this.singleWidth - dimension2D.getWidth()) / 2.0;
            d = this.getY(pin) + (this.singleHeight - dimension2D.getHeight()) / 2.0;
            Box2D box2D = Box2D.create(d2, d, dimension2D);
            this.boxes.put(pin, box2D);
            this.forbidden.add(box2D);
        }
        for (PinLink pinLink : skeleton.getPinLinks()) {
            this.drawPinLink((UGraphic)object, pinLink);
        }
        for (Map.Entry entry : this.images.entrySet()) {
            pin = (Pin)entry.getKey();
            iEntityImage = (IEntityImage)entry.getValue();
            dimension2D = iEntityImage.calculateDimension(object.getStringBounder());
            d2 = this.getX(pin) + (this.singleWidth - dimension2D.getWidth()) / 2.0;
            d = this.getY(pin) + (this.singleHeight - dimension2D.getHeight()) / 2.0;
            iEntityImage.drawU(object.apply(new UTranslate(d2, d)));
        }
        object.writeImage(outputStream, null, this.diagram.getDpi(fileFormatOption));
        return new ImageDataSimple((int)((Dimension2D)object2).getWidth(), (int)((Dimension2D)object2).getHeight());
    }

    private void drawPinLink(UGraphic uGraphic, PinLink pinLink) {
        double d = this.getCenterX(pinLink.getPin1());
        double d2 = this.getCenterY(pinLink.getPin1());
        double d3 = this.getCenterX(pinLink.getPin2());
        double d4 = this.getCenterY(pinLink.getPin2());
        Rose rose = new Rose();
        HtmlColor htmlColor = rose.getHtmlColor(this.diagram.getSkinParam(), ColorParam.classArrow);
        ArrayList<Box2D> arrayList = new ArrayList<Box2D>(this.forbidden);
        arrayList.remove(this.boxes.get(pinLink.getPin1()));
        arrayList.remove(this.boxes.get(pinLink.getPin2()));
        SmartConnection smartConnection = new SmartConnection(d, d2, d3, d4, arrayList);
        smartConnection.draw(uGraphic, htmlColor);
    }

    private IEntityImage computeImage(ILeaf iLeaf) {
        IEntityImage iEntityImage = CucaDiagramFileMakerSvek2.createEntityImageBlock(iLeaf, this.diagram.getSkinParam(), false, this.diagram, null);
        return iEntityImage;
    }
}

