/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jcckit;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.command.PSystemBasicFactory1317;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.jcckit.PSystemJcckit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemJcckitFactory1317
extends PSystemBasicFactory1317<PSystemJcckit> {
    private StringBuilder data;
    private int width;
    private int height;

    public PSystemJcckitFactory1317(DiagramType diagramType) {
        super(diagramType);
    }

    @Override
    public PSystemJcckit init(String string) {
        this.data = null;
        this.width = 640;
        this.height = 400;
        if (this.getDiagramType() == DiagramType.UML) {
            return null;
        }
        if (this.getDiagramType() == DiagramType.JCCKIT) {
            this.extractDimension(string);
            this.data = new StringBuilder();
            return this.createSystem();
        }
        throw new IllegalStateException(this.getDiagramType().name());
    }

    private void extractDimension(String string) {
        Pattern pattern = Pattern.compile("\\((\\d+),(\\d+)\\)");
        Matcher matcher = pattern.matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            this.width = Integer.parseInt(matcher.group(1));
            this.height = Integer.parseInt(matcher.group(2));
        }
    }

    String getDimension() {
        return "" + this.width + "-" + this.height;
    }

    private PSystemJcckit createSystem() {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(this.data.toString()));
        }
        catch (IOException iOException) {
            Log.error("Error " + iOException);
            iOException.printStackTrace();
            return null;
        }
        return new PSystemJcckit(properties, this.width, this.height);
    }

    @Override
    public PSystemJcckit executeLine(PSystemJcckit pSystemJcckit, String string) {
        if (pSystemJcckit == null && string.startsWith("jcckit")) {
            this.data = new StringBuilder();
            this.extractDimension(string);
            return this.createSystem();
        }
        if (this.data == null) {
            return null;
        }
        this.data.append(string.trim());
        this.data.append("\n");
        return this.createSystem();
    }
}

