/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.project.Item;
import net.sourceforge.plantuml.project.Project;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class ItemHeader {
    private final UFont font = new UFont("Serif", 0, 9);
    private final Project project;
    private final FontConfiguration fontConfig = new FontConfiguration(this.font, HtmlColorUtils.BLACK);

    public ItemHeader(Project project) {
        this.project = project;
    }

    public void draw(UGraphic uGraphic, double d, double d2) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK));
        uGraphic.apply(new UTranslate(d, d2)).draw(new URectangle(this.getWidth(stringBounder), this.getHeight(stringBounder)));
        for (Item item : this.project.getValidItems()) {
            TextBlock textBlock = TextBlockUtils.create(Display.asList("" + item.getCode()), this.fontConfig, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
            textBlock.drawU(uGraphic.apply(new UTranslate(d, d2)));
            uGraphic.apply(new UTranslate(d, d2 += dimension2D.getHeight())).draw(new ULine(this.getWidth(stringBounder), 0.0));
        }
    }

    public double getWidth(StringBounder stringBounder) {
        double d = 0.0;
        for (Item item : this.project.getValidItems()) {
            Dimension2D dimension2D = stringBounder.calculateDimension(this.font, item.getCode());
            d = Math.max(d, dimension2D.getWidth());
        }
        return d;
    }

    public double getHeight(StringBounder stringBounder) {
        double d = 0.0;
        for (Item item : this.project.getValidItems()) {
            Dimension2D dimension2D = stringBounder.calculateDimension(this.font, item.getCode());
            d += dimension2D.getHeight();
        }
        return d;
    }

    public double getPosition(StringBounder stringBounder, Item item) {
        double d = 0.0;
        for (Item item2 : this.project.getValidItems()) {
            if (item2 == item) {
                return d;
            }
            Dimension2D dimension2D = stringBounder.calculateDimension(this.font, item2.getCode());
            d += dimension2D.getHeight();
        }
        throw new IllegalArgumentException();
    }
}

