/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.StringTokenizer;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandArrow
extends SingleLineCommand2<SequenceDiagram> {
    public CommandArrow() {
        super(CommandArrow.getRegexConcat());
    }

    public static String getColorOrStylePattern() {
        return "(?:\\[((?:#\\w+|dotted|dashed|bold|hidden)(?:,#\\w+|,dotted|,dashed|,bold|,hidden)*)\\])?";
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexOr("PART1", new RegexLeaf("PART1CODE", "([\\p{L}0-9_.@]+)"), new RegexLeaf("PART1LONG", "\"([^\"]+)\""), new RegexLeaf("PART1LONGCODE", "\"([^\"]+)\"\\s*as\\s+([\\p{L}0-9_.@]+)"), new RegexLeaf("PART1CODELONG", "([\\p{L}0-9_.@]+)\\s+as\\s*\"([^\"]+)\"")), new RegexLeaf("\\s*"), new RegexLeaf("ARROW_DRESSING1", "( [ox]|(?: [ox])?<<?|(?: [ox])?//?|(?: [ox])?\\\\\\\\?)?"), new RegexOr(new RegexConcat(new RegexLeaf("ARROW_BODYA1", "(-+)"), new RegexLeaf("ARROW_STYLE1", CommandArrow.getColorOrStylePattern()), new RegexLeaf("ARROW_BODYB1", "(-*)")), new RegexConcat(new RegexLeaf("ARROW_BODYA2", "(-*)"), new RegexLeaf("ARROW_STYLE2", CommandArrow.getColorOrStylePattern()), new RegexLeaf("ARROW_BODYB2", "(-+)"))), new RegexLeaf("ARROW_DRESSING2", "(>>?(?:[ox] )?|//?(?:[ox] )?|\\\\\\\\?(?:[ox] )?|[ox] )?"), new RegexLeaf("\\s*"), new RegexOr("PART2", new RegexLeaf("PART2CODE", "([\\p{L}0-9_.@]+)"), new RegexLeaf("PART2LONG", "\"([^\"]+)\""), new RegexLeaf("PART2LONGCODE", "\"([^\"]+)\"\\s*as\\s+([\\p{L}0-9_.@]+)"), new RegexLeaf("PART2CODELONG", "([\\p{L}0-9_.@]+)\\s+as\\s*\"([^\"]+)\"")), new RegexLeaf("\\s*"), new RegexLeaf("ACTIVATION", "(?:([+*!-]+)?)"), new RegexLeaf("\\s*"), new RegexLeaf("LIFECOLOR", "(?:(#\\w+)?)"), new RegexLeaf("\\s*"), new RegexLeaf("MESSAGE", "(?::\\s*(.*))?$"));
    }

    private Participant getOrCreateParticipant(SequenceDiagram sequenceDiagram, RegexResult regexResult, String string) {
        Display display;
        String string2;
        if (regexResult.get(string + "CODE", 0) != null) {
            string2 = regexResult.get(string + "CODE", 0);
            display = Display.getWithNewlines(string2);
        } else if (regexResult.get(string + "LONG", 0) != null) {
            string2 = regexResult.get(string + "LONG", 0);
            display = Display.getWithNewlines(string2);
        } else if (regexResult.get(string + "LONGCODE", 0) != null) {
            display = Display.getWithNewlines(regexResult.get(string + "LONGCODE", 0));
            string2 = regexResult.get(string + "LONGCODE", 1);
        } else {
            if (regexResult.get(string + "CODELONG", 0) != null) {
                String string3 = regexResult.get(string + "CODELONG", 0);
                Display display2 = Display.getWithNewlines(regexResult.get(string + "CODELONG", 1));
                return sequenceDiagram.getOrCreateParticipant(string3, display2);
            }
            throw new IllegalStateException();
        }
        return sequenceDiagram.getOrCreateParticipant(string2, display);
    }

    private boolean contains(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, RegexResult regexResult) {
        String string;
        ArrowConfiguration arrowConfiguration;
        boolean bl;
        boolean bl2;
        Participant participant;
        Participant participant2;
        String string2 = CommandLinkClass.notNull(regexResult.get("ARROW_DRESSING1", 0)).toLowerCase();
        String string3 = CommandLinkClass.notNull(regexResult.get("ARROW_DRESSING2", 0)).toLowerCase();
        boolean bl3 = this.contains(string3, ">", "\\", "/", "x");
        boolean bl4 = this.contains(string2, "x", "<", "\\", "/");
        if (bl3) {
            participant2 = this.getOrCreateParticipant(sequenceDiagram, regexResult, "PART1");
            participant = this.getOrCreateParticipant(sequenceDiagram, regexResult, "PART2");
            bl2 = string2.contains("o");
            bl = string3.contains("o");
        } else if (bl4) {
            participant = this.getOrCreateParticipant(sequenceDiagram, regexResult, "PART1");
            participant2 = this.getOrCreateParticipant(sequenceDiagram, regexResult, "PART2");
            bl2 = string3.contains("o");
            bl = string2.contains("o");
        } else {
            return CommandExecutionResult.error("Illegal sequence arrow");
        }
        boolean bl5 = this.contains(string2, "<<", "\\\\", "//") || this.contains(string3, ">>", "\\\\", "//");
        boolean bl6 = this.getLength(regexResult) > 1;
        Display display = regexResult.get("MESSAGE", 0) == null ? Display.asList("") : Display.getWithNewlines(regexResult.get("MESSAGE", 0));
        ArrowConfiguration arrowConfiguration2 = arrowConfiguration = bl4 && bl3 ? ArrowConfiguration.withDirectionBoth() : ArrowConfiguration.withDirectionNormal();
        if (bl6) {
            arrowConfiguration = arrowConfiguration.withDotted();
        }
        if (bl5) {
            arrowConfiguration = arrowConfiguration.withHead(ArrowHead.ASYNC);
        }
        if (string3.contains("\\") || string2.contains("/")) {
            arrowConfiguration = arrowConfiguration.withPart(ArrowPart.TOP_PART);
        }
        if (string3.contains("/") || string2.contains("\\")) {
            arrowConfiguration = arrowConfiguration.withPart(ArrowPart.BOTTOM_PART);
        }
        if (bl) {
            arrowConfiguration = arrowConfiguration.withDecorationEnd(ArrowDecoration.CIRCLE);
        }
        if (bl2) {
            arrowConfiguration = arrowConfiguration.withDecorationStart(ArrowDecoration.CIRCLE);
        }
        if (string2.contains("x")) {
            arrowConfiguration = arrowConfiguration.withHead2(ArrowHead.CROSSX);
        }
        if (string3.contains("x")) {
            arrowConfiguration = arrowConfiguration.withHead2(ArrowHead.CROSSX);
        }
        arrowConfiguration = CommandArrow.applyStyle(regexResult.getLazzy("ARROW_STYLE", 0), arrowConfiguration);
        String string4 = regexResult.get("ACTIVATION", 0);
        if (string4 != null && string4.charAt(0) == '*') {
            sequenceDiagram.activate(participant, LifeEventType.CREATE, null);
        }
        if ((string = sequenceDiagram.addMessage(new Message(participant2, participant, display, arrowConfiguration, sequenceDiagram.getNextMessageNumber()))) != null) {
            return CommandExecutionResult.error(string);
        }
        HtmlColor htmlColor = HtmlColorUtils.getColorIfValid(regexResult.get("LIFECOLOR", 0));
        if (string4 != null) {
            switch (string4.charAt(0)) {
                case '+': {
                    sequenceDiagram.activate(participant, LifeEventType.ACTIVATE, htmlColor);
                    break;
                }
                case '-': {
                    sequenceDiagram.activate(participant2, LifeEventType.DEACTIVATE, null);
                    break;
                }
                case '!': {
                    sequenceDiagram.activate(participant, LifeEventType.DESTROY, null);
                    break;
                }
            }
        } else if (sequenceDiagram.isAutoactivate() && arrowConfiguration.getHead() == ArrowHead.NORMAL) {
            if (arrowConfiguration.isDotted()) {
                sequenceDiagram.activate(participant2, LifeEventType.DEACTIVATE, null);
            } else {
                sequenceDiagram.activate(participant, LifeEventType.ACTIVATE, htmlColor);
            }
        }
        return CommandExecutionResult.ok();
    }

    private int getLength(RegexResult regexResult) {
        String string;
        String string2 = regexResult.getLazzy("ARROW_BODYA", 0);
        if (string2 == null) {
            string2 = "";
        }
        if ((string = regexResult.getLazzy("ARROW_BODYB", 0)) == null) {
            string = "";
        }
        return string2.length() + string.length();
    }

    public static ArrowConfiguration applyStyle(String string, ArrowConfiguration arrowConfiguration) {
        if (string == null) {
            return arrowConfiguration;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("dashed") || string2.equalsIgnoreCase("bold") || string2.equalsIgnoreCase("dotted") || string2.equalsIgnoreCase("hidden")) continue;
            arrowConfiguration = arrowConfiguration.withColor(HtmlColorUtils.getColorIfValid(string2));
        }
        return arrowConfiguration;
    }
}

