/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.util.ArrayList;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;

class GrayComponent
extends AbstractComponent {
    private static final UFont NORMAL = new UFont("SansSerif", 0, 7);
    private final ComponentType type;

    public GrayComponent(ComponentType componentType) {
        this.type = componentType;
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic = uGraphic.apply(new UChangeBackColor(HtmlColorUtils.LIGHT_GRAY)).apply(new UChangeColor(HtmlColorUtils.BLACK));
        uGraphic.draw(new URectangle(this.getPreferredWidth(stringBounder), this.getPreferredHeight(stringBounder)));
        String string = this.type.name();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); i += 9) {
            arrayList.add(string.substring(i, Math.min(i + 9, string.length())));
        }
        TextBlock textBlock = TextBlockUtils.create(new Display(arrayList), new FontConfiguration(NORMAL, HtmlColorUtils.BLACK), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        textBlock.drawU(uGraphic);
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return 42.0;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return 42.0;
    }
}

