/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.StickMan;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentBlueModernActor
extends AbstractTextualComponent {
    private final StickMan stickman;
    private final boolean head;

    public ComponentBlueModernActor(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, UFont uFont, Display display, boolean bl, SpriteContainer spriteContainer) {
        super(display, htmlColor3, uFont, HorizontalAlignment.CENTER, 3, 3, 0, spriteContainer, 0.0);
        this.head = bl;
        this.stickman = new StickMan(htmlColor, htmlColor2);
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        uGraphic = uGraphic.apply(new UChangeColor(this.getFontColor()));
        TextBlock textBlock = this.getTextBlock();
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = (this.getPreferredWidth(stringBounder) - this.stickman.getPreferredWidth()) / 2.0;
        if (this.head) {
            textBlock.drawU(uGraphic.apply(new UTranslate(this.getTextMiddlePostion(stringBounder), this.stickman.getPreferredHeight())));
            uGraphic = uGraphic.apply(new UTranslate(d, 0.0));
        } else {
            textBlock.drawU(uGraphic.apply(new UTranslate(this.getTextMiddlePostion(stringBounder), 0.0)));
            uGraphic = uGraphic.apply(new UTranslate(d, this.getTextHeight(stringBounder)));
        }
        this.stickman.drawU(uGraphic);
    }

    private double getTextMiddlePostion(StringBounder stringBounder) {
        return (this.getPreferredWidth(stringBounder) - this.getTextWidth(stringBounder)) / 2.0;
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.stickman.getPreferredHeight() + this.getTextHeight(stringBounder);
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return Math.max(this.stickman.getPreferredWidth(), this.getTextWidth(stringBounder));
    }
}

