/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Boundary
implements TextBlock {
    private final double margin = 4.0;
    private final double radius = 12.0;
    private final double left = 17.0;
    private final HtmlColor backgroundColor;
    private final HtmlColor foregroundColor;
    private final double thickness;
    private final double deltaShadow;

    public Boundary(HtmlColor htmlColor, HtmlColor htmlColor2, double d, double d2) {
        this.backgroundColor = htmlColor;
        this.foregroundColor = htmlColor2;
        this.deltaShadow = d;
        this.thickness = d2;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        double d = 0.0;
        double d2 = 0.0;
        d += 4.0;
        d2 += 4.0;
        uGraphic = uGraphic.apply(new UStroke(this.thickness)).apply(new UChangeBackColor(this.backgroundColor)).apply(new UChangeColor(this.foregroundColor));
        UEllipse uEllipse = new UEllipse(24.0, 24.0);
        uEllipse.setDeltaShadow(this.deltaShadow);
        ULine uLine = new ULine(0.0, 24.0);
        uLine.setDeltaShadow(this.deltaShadow);
        uGraphic.apply(new UTranslate(d, d2)).draw(uLine);
        ULine uLine2 = new ULine(17.0, 0.0);
        uLine2.setDeltaShadow(this.deltaShadow);
        uGraphic.apply(new UTranslate(d, d2 + 12.0)).draw(uLine2);
        uGraphic.apply(new UTranslate(d + 17.0, d2)).draw(uEllipse);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(49.0, 32.0);
    }

    @Override
    public List<Url> getUrls() {
        return Collections.emptyList();
    }
}

