/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.api.ImageDataComplex;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramSimplifierActivity;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramSimplifierState;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.DecorateEntityImage;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;
import net.sourceforge.plantuml.ugraphic.visio.UGraphicVdx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramFileMakerSvek
implements CucaDiagramFileMaker {
    private final CucaDiagram diagram;
    private final List<BufferedImage> flashcodes;
    private static final StringBounder stringBounder;
    private String warningOrError;

    public CucaDiagramFileMakerSvek(CucaDiagram cucaDiagram, List<BufferedImage> list) throws IOException {
        this.diagram = cucaDiagram;
        this.flashcodes = list;
    }

    @Override
    public ImageData createFile(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException {
        try {
            return this.createFileInternal(outputStream, list, fileFormatOption);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new IOException(interruptedException);
        }
    }

    private ImageData createFileInternal(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        String string;
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            new CucaDiagramSimplifierActivity(this.diagram, list);
        } else if (this.diagram.getUmlDiagramType() == UmlDiagramType.STATE) {
            new CucaDiagramSimplifierState(this.diagram, list);
        }
        DotData dotData = new DotData(this.diagram.getEntityFactory().getRootGroup(), this.getOrderedLinks(), this.diagram.getLeafs().values(), this.diagram.getUmlDiagramType(), this.diagram.getSkinParam(), this.diagram.getRankdir(), this.diagram, this.diagram, this.diagram.getColorMapper(), this.diagram.getEntityFactory(), this.diagram.isHideEmptyDescriptionForState());
        CucaDiagramFileMakerSvek2 cucaDiagramFileMakerSvek2 = new CucaDiagramFileMakerSvek2(dotData, this.diagram.getEntityFactory(), false);
        TextBlockBackcolored textBlockBackcolored = cucaDiagramFileMakerSvek2.createFile(this.diagram.getDotStringSkek());
        textBlockBackcolored = this.addLegend(textBlockBackcolored);
        textBlockBackcolored = this.addTitle(textBlockBackcolored);
        textBlockBackcolored = this.addHeaderAndFooter(textBlockBackcolored);
        Dimension2D dimension2D = textBlockBackcolored.calculateDimension(stringBounder);
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.PNG) {
            this.createPng(outputStream, fileFormatOption, textBlockBackcolored, dimension2D);
        } else if (fileFormat == FileFormat.SVG) {
            this.createSvg(outputStream, fileFormatOption, textBlockBackcolored, dimension2D);
        } else if (fileFormat == FileFormat.VDX) {
            this.createVdx(outputStream, fileFormatOption, textBlockBackcolored, dimension2D);
        } else if (fileFormat == FileFormat.EPS) {
            this.createEps(outputStream, fileFormatOption, textBlockBackcolored, dimension2D);
        } else {
            throw new UnsupportedOperationException(fileFormat.toString());
        }
        double d = 0.0;
        double d2 = 0.0;
        if (textBlockBackcolored instanceof DecorateEntityImage) {
            d += ((DecorateEntityImage)textBlockBackcolored).getDeltaX();
            d2 += ((DecorateEntityImage)textBlockBackcolored).getDeltaY();
        }
        Dimension2D dimension2D2 = Dimension2DDouble.delta(dimension2D, d, d2);
        CMapData cMapData = null;
        if (this.diagram.hasUrl() && fileFormatOption.getFileFormat() == FileFormat.PNG) {
            cMapData = this.cmapString(cucaDiagramFileMakerSvek2);
        }
        this.warningOrError = (string = this.diagram.getSkinParam().getValue("widthwarning")) != null && string.matches("\\d+") ? cucaDiagramFileMakerSvek2.getBibliotekon().getWarningOrError(Integer.parseInt(string)) : null;
        return new ImageDataComplex(dimension2D2, cMapData, this.getWarningOrError());
    }

    private List<Link> getOrderedLinks() {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            this.addLinkNew(arrayList, link);
        }
        return arrayList;
    }

    private void addLinkNew(List<Link> list, Link link) {
        for (int i = 0; i < list.size(); ++i) {
            Link link2 = list.get(i);
            if (!link2.sameConnections(link)) continue;
            while (i < list.size() && list.get(i).sameConnections(link)) {
                ++i;
            }
            if (i == list.size()) {
                list.add(link);
            } else {
                list.add(i, link);
            }
            return;
        }
        list.add(link);
    }

    private String getWarningOrError() {
        return this.warningOrError;
    }

    private CMapData cmapString(CucaDiagramFileMakerSvek2 cucaDiagramFileMakerSvek2) {
        Object object;
        CMapData cMapData = new CMapData();
        ArrayList<ILeaf> arrayList = new ArrayList<ILeaf>(this.diagram.getLeafs().values());
        arrayList.addAll(this.diagram.getGroups(false));
        int n = 1;
        for (IEntity removeable : arrayList) {
            object = new ArrayList<Url>(removeable.getUrls());
            Collections.reverse(object);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Url url = (Url)iterator.next();
                this.appendUrl(cMapData, n, url);
                ++n;
            }
        }
        for (Link link : this.diagram.getLinks()) {
            object = link.getUrl();
            if (object == null) continue;
            this.appendUrl(cMapData, n, (Url)object);
            ++n;
        }
        return cMapData;
    }

    private void appendUrl(CMapData cMapData, int n, Url url) {
        cMapData.appendString("<area shape=\"rect\" id=\"id");
        cMapData.appendLong(n);
        cMapData.appendString("\" href=\"");
        cMapData.appendString(url.getUrl());
        cMapData.appendString("\" title=\"");
        cMapData.appendString(url.getTooltip());
        cMapData.appendString("\" alt=\"\" coords=\"");
        cMapData.appendString(url.getCoords());
        cMapData.appendString("\"/>");
        cMapData.appendString("\n");
    }

    private TextBlockBackcolored addHeaderAndFooter(TextBlockBackcolored textBlockBackcolored) {
        Display display = this.diagram.getFooter();
        Display display2 = this.diagram.getHeader();
        if (display == null && display2 == null) {
            return textBlockBackcolored;
        }
        TextBlock textBlock = display == null ? null : TextBlockUtils.create(display, new FontConfiguration(this.getFont(FontParam.FOOTER), this.getFontColor(FontParam.FOOTER, null)), this.diagram.getFooterAlignment(), this.diagram.getSkinParam());
        TextBlock textBlock2 = display2 == null ? null : TextBlockUtils.create(display2, new FontConfiguration(this.getFont(FontParam.HEADER), this.getFontColor(FontParam.HEADER, null)), this.diagram.getHeaderAlignment(), this.diagram.getSkinParam());
        return new DecorateEntityImage(textBlockBackcolored, textBlock2, this.diagram.getHeaderAlignment(), textBlock, this.diagram.getFooterAlignment());
    }

    private TextBlockBackcolored addTitle(TextBlockBackcolored textBlockBackcolored) {
        Display display = this.diagram.getTitle();
        if (display == null) {
            return textBlockBackcolored;
        }
        TextBlock textBlock = TextBlockUtils.create(display, new FontConfiguration(this.getFont(FontParam.TITLE), this.getFontColor(FontParam.TITLE, null)), HorizontalAlignment.CENTER, this.diagram.getSkinParam());
        return DecorateEntityImage.addTop(textBlockBackcolored, textBlock, HorizontalAlignment.CENTER);
    }

    private TextBlockBackcolored addLegend(TextBlockBackcolored textBlockBackcolored) {
        Display display = this.diagram.getLegend();
        if (display == null) {
            return textBlockBackcolored;
        }
        TextBlock textBlock = EntityImageLegend.create(display, this.diagram.getSkinParam());
        return DecorateEntityImage.addBottom(textBlockBackcolored, textBlock, this.diagram.getLegendAlignment());
    }

    private final UFont getFont(FontParam fontParam) {
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return iSkinParam.getFont(fontParam, null);
    }

    private final HtmlColor getFontColor(FontParam fontParam, String string) {
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return iSkinParam.getFontHtmlColor(fontParam, string);
    }

    private void createPng(OutputStream outputStream, FileFormatOption fileFormatOption, TextBlockBackcolored textBlockBackcolored, Dimension2D dimension2D) throws IOException {
        Scale scale = this.diagram.getScale();
        double d = scale == null ? this.diagram.getDpiFactor(fileFormatOption) : scale.getScale(dimension2D.getWidth(), dimension2D.getHeight());
        UGraphicG2d uGraphicG2d = (UGraphicG2d)fileFormatOption.createUGraphic(this.diagram.getSkinParam().getColorMapper(), d, dimension2D, textBlockBackcolored.getBackcolor(), this.diagram.isRotation());
        textBlockBackcolored.drawU(uGraphicG2d);
        PngIO.write((RenderedImage)uGraphicG2d.getBufferedImage(), outputStream, this.diagram.getMetadata(), this.diagram.getDpi(fileFormatOption));
    }

    private void createSvg(OutputStream outputStream, FileFormatOption fileFormatOption, TextBlockBackcolored textBlockBackcolored, Dimension2D dimension2D) throws IOException {
        Color color = Color.WHITE;
        if (textBlockBackcolored.getBackcolor() instanceof HtmlColorSimple) {
            color = this.diagram.getSkinParam().getColorMapper().getMappedColor(textBlockBackcolored.getBackcolor());
        }
        UGraphicSvg uGraphicSvg = textBlockBackcolored.getBackcolor() instanceof HtmlColorGradient ? new UGraphicSvg(this.diagram.getSkinParam().getColorMapper(), (HtmlColorGradient)textBlockBackcolored.getBackcolor(), false) : (color == null || color.equals(Color.WHITE) ? new UGraphicSvg(this.diagram.getSkinParam().getColorMapper(), false) : new UGraphicSvg(this.diagram.getSkinParam().getColorMapper(), StringUtils.getAsHtml(color), false));
        textBlockBackcolored.drawU(uGraphicSvg);
        uGraphicSvg.createXml(outputStream);
    }

    private void createVdx(OutputStream outputStream, FileFormatOption fileFormatOption, TextBlockBackcolored textBlockBackcolored, Dimension2D dimension2D) throws IOException {
        UGraphicVdx uGraphicVdx = new UGraphicVdx(this.diagram.getSkinParam().getColorMapper());
        textBlockBackcolored.drawU(uGraphicVdx);
        uGraphicVdx.createVsd(outputStream);
    }

    private void createEps(OutputStream outputStream, FileFormatOption fileFormatOption, TextBlockBackcolored textBlockBackcolored, Dimension2D dimension2D) throws IOException {
        UGraphicEps uGraphicEps = new UGraphicEps(this.diagram.getSkinParam().getColorMapper(), EpsStrategy.getDefault2());
        textBlockBackcolored.drawU(uGraphicEps);
        outputStream.write(uGraphicEps.getEPSCode().getBytes());
    }

    static {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, Color.WHITE);
        stringBounder = StringBounderUtils.asStringBounder(emptyImageBuilder.getGraphics2D());
    }
}

