/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InnerStateConcurrent
implements IEntityImage {
    private final IEntityImage im;
    public static final double THICKNESS_BORDER = 1.5;
    private static final int DASH = 8;

    public InnerStateConcurrent(IEntityImage iEntityImage) {
        this.im = iEntityImage;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        URectangle uRectangle = new URectangle(dimension2D.getWidth(), dimension2D.getHeight());
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK));
        uGraphic.apply(new UStroke(8.0, 10.0, 1.5)).draw(uRectangle);
        this.im.drawU(uGraphic);
    }

    @Override
    public HtmlColor getBackcolor() {
        return null;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.im.calculateDimension(stringBounder);
        return dimension2D;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public int getShield() {
        return 0;
    }

    @Override
    public boolean isHidden() {
        return this.im.isHidden();
    }

    @Override
    public final List<Url> getUrls() {
        return Collections.emptyList();
    }
}

