/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageActivity
extends AbstractEntityImage {
    public static final int CORNER = 25;
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final List<Url> url;

    public EntityImageActivity(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
        Stereotype stereotype = iLeaf.getStereotype();
        this.desc = TextBlockUtils.create(iLeaf.getDisplay(), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.ACTIVITY, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.ACTIVITY, stereotype)), HorizontalAlignment.CENTER, iSkinParam);
        this.url = iLeaf.getUrls();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.desc.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dimension2D, 20.0);
    }

    public final void drawU(UGraphic uGraphic) {
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.calculateDimension(stringBounder);
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        URectangle uRectangle = new URectangle(d, d2, 25.0, 25.0);
        if (this.getSkinParam().shadowing()) {
            uRectangle.setDeltaShadow(4.0);
        }
        uGraphic = uGraphic.apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.activityBorder, this.getStereo())));
        HtmlColor htmlColor = this.getEntity().getSpecificBackColor();
        if (htmlColor == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.activityBackground, this.getStereo());
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(htmlColor));
        uGraphic.apply(new UStroke(1.5)).draw(uRectangle);
        this.desc.drawU(uGraphic.apply(new UTranslate(10.0, 10.0)));
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

