/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageComponent
extends AbstractEntityImage {
    private final TextBlock desc;
    private final List<Url> url;
    private TextBlock stereo = TextBlockUtils.empty(0.0, 0.0);
    private PackageStyle style;
    private USymbol symbol;

    public EntityImageComponent(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
        Stereotype stereotype = iLeaf.getStereotype();
        this.desc = TextBlockUtils.create(iLeaf.getDisplay(), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.COMPONENT, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.COMPONENT, stereotype)), HorizontalAlignment.CENTER, iSkinParam);
        PackageStyle packageStyle = this.style = stereotype == null ? null : stereotype.getPackageStyle();
        if (this.style == null) {
            PackageStyle packageStyle2 = this.style = iSkinParam.useUml2ForComponent() ? PackageStyle.COMPONENT2 : PackageStyle.COMPONENT1;
            if (stereotype != null && stereotype.getLabel() != null) {
                this.stereo = TextBlockUtils.create(Display.getWithNewlines(stereotype.getLabel()), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.COMPONENT_STEREOTYPE, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.COMPONENT_STEREOTYPE, null)), HorizontalAlignment.CENTER, iSkinParam);
            }
        }
        this.symbol = this.getUSymbol();
        this.url = iLeaf.getUrls();
    }

    private USymbol getUSymbol() {
        if (this.style == PackageStyle.NODE) {
            return USymbol.NODE;
        }
        return null;
    }

    private Margin getSuppDimension() {
        if (this.style == PackageStyle.COMPONENT1) {
            return new Margin(10.0, 10.0, 10.0, 10.0);
        }
        if (this.style == PackageStyle.COMPONENT2) {
            return new Margin(10.0, 14.0, 16.0, 11.0);
        }
        if (this.style == PackageStyle.NODE) {
            return new Margin(15.0, 25.0, 20.0, 10.0);
        }
        if (this.style == PackageStyle.FOLDER) {
            return new Margin(10.0, 10.0, 15.0, 5.0);
        }
        if (this.style == PackageStyle.RECT) {
            return new Margin(10.0, 10.0, 10.0, 10.0);
        }
        if (this.style == PackageStyle.FRAME) {
            return new Margin(10.0, 10.0, 15.0, 5.0);
        }
        if (this.style == PackageStyle.CLOUD) {
            return new Margin(15.0, 15.0, 15.0, 15.0);
        }
        if (this.style == PackageStyle.DATABASE) {
            return new Margin(10.0, 10.0, 25.0, 10.0);
        }
        if (this.style == PackageStyle.STORAGE) {
            return new Margin(15.0, 15.0, 15.0, 15.0);
        }
        if (this.style == PackageStyle.ARTIFACT) {
            return new Margin(10.0, 10.0, 10.0, 10.0);
        }
        if (this.style == PackageStyle.AGENT) {
            return new Margin(10.0, 10.0, 10.0, 10.0);
        }
        return new Margin(0.0, 0.0, 0.0, 0.0);
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = Dimension2DDouble.mergeTB(this.desc.calculateDimension(stringBounder), this.stereo.calculateDimension(stringBounder));
        Margin margin = this.getSuppDimension();
        return Dimension2DDouble.delta(dimension2D, margin.getWidth(), margin.getHeight());
    }

    private void drawStyled(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.calculateDimension(stringBounder);
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        this.style.drawU(uGraphic, new Dimension2DDouble(d, d2), null, this.getSkinParam().shadowing());
        Dimension2D dimension2D2 = this.calculateDimension(stringBounder);
        Dimension2D dimension2D3 = this.desc.calculateDimension(stringBounder);
        Dimension2D dimension2D4 = this.stereo.calculateDimension(stringBounder);
        Dimension2D dimension2D5 = Dimension2DDouble.mergeTB(dimension2D4, dimension2D3);
        Margin margin = this.getSuppDimension();
        double d3 = margin.x1 + (dimension2D2.getWidth() - margin.getWidth() - dimension2D3.getWidth()) / 2.0;
        double d4 = margin.y1 + (dimension2D2.getHeight() - margin.getHeight() - dimension2D5.getHeight()) / 2.0;
        this.desc.drawU(uGraphic.apply(new UTranslate(d3, d4 + dimension2D4.getHeight())));
        double d5 = margin.x1 + (dimension2D2.getWidth() - margin.getWidth() - dimension2D4.getWidth()) / 2.0;
        this.stereo.drawU(uGraphic.apply(new UTranslate(d5, d4)));
    }

    public final void drawU(UGraphic uGraphic) {
        HtmlColor htmlColor;
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        if ((htmlColor = this.getEntity().getSpecificBackColor()) == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.componentBackground, this.getStereo());
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(htmlColor));
        if (this.symbol == null) {
            uGraphic = uGraphic.apply(new UStroke(1.5)).apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.componentBorder, this.getStereo())));
            this.drawStyled(uGraphic);
        } else {
            SymbolContext symbolContext = new SymbolContext(htmlColor, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.componentBorder, this.getStereo())).withStroke(new UStroke(1.5)).withShadow(this.getSkinParam().shadowing());
            this.symbol.asSmall(TextBlockUtils.mergeTB(this.desc, this.stereo, HorizontalAlignment.CENTER), null, symbolContext).drawU(uGraphic);
        }
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }

    static class Margin {
        private final double x1;
        private final double x2;
        private final double y1;
        private final double y2;

        private Margin(double d, double d2, double d3, double d4) {
            this.x1 = d;
            this.x2 = d2;
            this.y1 = d3;
            this.y2 = d4;
        }

        private double getWidth() {
            return this.x1 + this.x2;
        }

        private double getHeight() {
            return this.y1 + this.y2;
        }
    }
}

