/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageComponentForDescriptionDiagram
extends AbstractEntityImage {
    private final List<Url> url;
    private final TextBlock asSmall;

    public EntityImageComponentForDescriptionDiagram(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
        Stereotype stereotype = iLeaf.getStereotype();
        USymbol uSymbol = iLeaf.getUSymbol();
        if (uSymbol == null) {
            throw new IllegalArgumentException();
        }
        BodyEnhanced bodyEnhanced = new BodyEnhanced(iLeaf.getDisplay(), this.getFontParam(uSymbol), iSkinParam, HorizontalAlignment.CENTER, stereotype, uSymbol.manageHorizontalLine(), false);
        this.url = iLeaf.getUrls();
        HtmlColor htmlColor = this.getEntity().getSpecificBackColor();
        if (htmlColor == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), this.getColorParamBack(uSymbol), this.getStereo());
        }
        HtmlColor htmlColor2 = SkinParamUtils.getColor(this.getSkinParam(), this.getColorParamBorder(uSymbol), this.getStereo());
        SymbolContext symbolContext = new SymbolContext(htmlColor, htmlColor2).withStroke(new UStroke(1.5)).withShadow(this.getSkinParam().shadowing());
        TextBlock textBlock = TextBlockUtils.empty(0.0, 0.0);
        if (stereotype != null && stereotype.getLabel() != null) {
            textBlock = TextBlockUtils.create(Display.getWithNewlines(stereotype.getLabel()), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), this.getFontParamStereotype(uSymbol), stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), this.getFontParamStereotype(uSymbol), null)), HorizontalAlignment.CENTER, iSkinParam);
        }
        this.asSmall = uSymbol.asSmall(bodyEnhanced, textBlock, symbolContext);
    }

    private FontParam getFontParamStereotype(USymbol uSymbol) {
        if (uSymbol == USymbol.COMPONENT1 || uSymbol == USymbol.COMPONENT2 || uSymbol == USymbol.INTERFACE) {
            return FontParam.COMPONENT_STEREOTYPE;
        }
        if (uSymbol == USymbol.ACTOR) {
            return FontParam.USECASE_ACTOR_STEREOTYPE;
        }
        if (uSymbol == USymbol.ARTIFACT || uSymbol == USymbol.FOLDER || uSymbol == USymbol.BOUNDARY || uSymbol == USymbol.ENTITY_DOMAIN || uSymbol == USymbol.CONTROL) {
            return FontParam.USECASE_ACTOR_STEREOTYPE;
        }
        return FontParam.USECASE_ACTOR_STEREOTYPE;
    }

    private FontParam getFontParam(USymbol uSymbol) {
        if (uSymbol == USymbol.COMPONENT1 || uSymbol == USymbol.COMPONENT2 || uSymbol == USymbol.INTERFACE) {
            return FontParam.COMPONENT;
        }
        if (uSymbol == USymbol.ACTOR) {
            return FontParam.USECASE_ACTOR;
        }
        if (uSymbol == USymbol.ARTIFACT || uSymbol == USymbol.FOLDER || uSymbol == USymbol.BOUNDARY || uSymbol == USymbol.ENTITY_DOMAIN || uSymbol == USymbol.CONTROL) {
            return FontParam.USECASE_ACTOR;
        }
        return FontParam.USECASE_ACTOR;
    }

    private ColorParam getColorParamBorder(USymbol uSymbol) {
        if (uSymbol == USymbol.COMPONENT1 || uSymbol == USymbol.COMPONENT2 || uSymbol == USymbol.INTERFACE) {
            return ColorParam.componentBorder;
        }
        if (uSymbol == USymbol.ACTOR) {
            return ColorParam.usecaseActorBorder;
        }
        if (uSymbol == USymbol.ARTIFACT || uSymbol == USymbol.FOLDER || uSymbol == USymbol.BOUNDARY || uSymbol == USymbol.ENTITY_DOMAIN || uSymbol == USymbol.CONTROL) {
            return ColorParam.usecaseActorBorder;
        }
        return ColorParam.usecaseActorBorder;
    }

    private ColorParam getColorParamBack(USymbol uSymbol) {
        if (uSymbol == USymbol.COMPONENT1 || uSymbol == USymbol.COMPONENT2 || uSymbol == USymbol.INTERFACE) {
            return ColorParam.componentBackground;
        }
        if (uSymbol == USymbol.ACTOR) {
            return ColorParam.usecaseActorBackground;
        }
        if (uSymbol == USymbol.ARTIFACT || uSymbol == USymbol.FOLDER || uSymbol == USymbol.BOUNDARY || uSymbol == USymbol.ENTITY_DOMAIN || uSymbol == USymbol.CONTROL) {
            return ColorParam.usecaseActorBackground;
        }
        return ColorParam.usecaseActorBackground;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.asSmall.calculateDimension(stringBounder);
    }

    public final void drawU(UGraphic uGraphic) {
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        this.asSmall.drawU(uGraphic);
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

