/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.CompressionTransform;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class UGraphicCompress
implements UGraphic {
    private final UGraphic ug;
    private final CompressionTransform compressionTransform;
    private final UTranslate translate;

    public UGraphic apply(UChange uChange) {
        if (uChange instanceof UTranslate) {
            return new UGraphicCompress(this.ug, this.compressionTransform, this.translate.compose((UTranslate)uChange));
        }
        if (uChange instanceof UStroke || uChange instanceof UChangeBackColor || uChange instanceof UChangeColor) {
            return new UGraphicCompress(this.ug.apply(uChange), this.compressionTransform, this.translate);
        }
        throw new UnsupportedOperationException();
    }

    public UGraphicCompress(UGraphic uGraphic, CompressionTransform compressionTransform) {
        this(uGraphic, compressionTransform, new UTranslate());
    }

    private UGraphicCompress(UGraphic uGraphic, CompressionTransform compressionTransform, UTranslate uTranslate) {
        this.ug = uGraphic;
        this.compressionTransform = compressionTransform;
        this.translate = uTranslate;
    }

    public StringBounder getStringBounder() {
        return this.ug.getStringBounder();
    }

    public UParam getParam() {
        return this.ug.getParam();
    }

    public void draw(UShape uShape) {
        double d = this.translate.getDx();
        double d2 = this.translate.getDy();
        if (uShape instanceof ULine) {
            this.drawLine(d, d2, (ULine)uShape);
        } else {
            this.ug.apply(new UTranslate(d, this.ct(d2))).draw(uShape);
        }
    }

    private void drawLine(double d, double d2, ULine uLine) {
        this.drawLine(d, this.ct(d2), d + uLine.getDX(), this.ct(d2 + uLine.getDY()));
    }

    private double ct(double d) {
        return this.compressionTransform.transform(d);
    }

    private void drawLine(double d, double d2, double d3, double d4) {
        double d5 = Math.min(d, d3);
        double d6 = Math.max(d, d3);
        double d7 = Math.min(d2, d4);
        double d8 = Math.max(d2, d4);
        this.ug.apply(new UTranslate(d5, d7)).draw(new ULine(d6 - d5, d8 - d7));
    }

    public void writeImage(OutputStream outputStream, String string, int n) throws IOException {
        this.ug.writeImage(outputStream, string, n);
    }

    public ColorMapper getColorMapper() {
        return this.ug.getColorMapper();
    }

    public void startUrl(Url url) {
        this.ug.startUrl(url);
    }

    public void closeAction() {
        this.ug.closeAction();
    }
}

