/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPixel;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.g2d.DriverCenteredCharacterG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverDotPathG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverEllipseG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverImageG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverPathG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverPixelG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverPolygonG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverRectangleG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverTextG2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UGraphicG2d
extends AbstractUGraphic<Graphics2D>
implements EnsureVisible {
    private BufferedImage bufferedImage;
    private final double dpiFactor;
    private UAntiAliasing antiAliasing = UAntiAliasing.ANTI_ALIASING_ON;
    private List<Url> urls = new ArrayList<Url>();

    @Override
    public UGraphic apply(UChange uChange) {
        UGraphicG2d uGraphicG2d = (UGraphicG2d)super.apply(uChange);
        if (uChange instanceof UAntiAliasing) {
            uGraphicG2d.antiAliasing = (UAntiAliasing)uChange;
        }
        return uGraphicG2d;
    }

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicG2d(this);
    }

    private UGraphicG2d(UGraphicG2d uGraphicG2d) {
        super(uGraphicG2d);
        this.dpiFactor = uGraphicG2d.dpiFactor;
        this.bufferedImage = uGraphicG2d.bufferedImage;
        this.urls = uGraphicG2d.urls;
        this.antiAliasing = uGraphicG2d.antiAliasing;
        this.register(this.dpiFactor);
    }

    public UGraphicG2d(ColorMapper colorMapper, Graphics2D graphics2D, double d) {
        this(colorMapper, graphics2D, d, null);
    }

    public UGraphicG2d(ColorMapper colorMapper, Graphics2D graphics2D, double d, AffineTransform affineTransform) {
        super(colorMapper, graphics2D);
        this.dpiFactor = d;
        if (d != 1.0) {
            graphics2D.scale(d, d);
        }
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
        }
        this.register(d);
    }

    private void register(double d) {
        this.registerDriver(URectangle.class, new DriverRectangleG2d(d, this));
        this.registerDriver(UText.class, new DriverTextG2d(this));
        this.registerDriver(ULine.class, new DriverLineG2d(d));
        this.registerDriver(UPixel.class, new DriverPixelG2d());
        this.registerDriver(UPolygon.class, new DriverPolygonG2d(d, this));
        this.registerDriver(UEllipse.class, new DriverEllipseG2d(d, this));
        this.registerDriver(UImage.class, new DriverImageG2d());
        this.registerDriver(DotPath.class, new DriverDotPathG2d(this));
        this.registerDriver(UPath.class, new DriverPathG2d(d));
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterG2d());
    }

    @Override
    public StringBounder getStringBounder() {
        return StringBounderUtils.asStringBounder((Graphics2D)this.getGraphicObject());
    }

    @Override
    protected void beforeDraw() {
        super.beforeDraw();
        this.applyClip();
        this.antiAliasing.apply((Graphics2D)this.getGraphicObject());
    }

    private void applyClip() {
        UClip uClip = this.getClip();
        if (uClip == null) {
            ((Graphics2D)this.getGraphicObject()).setClip(null);
        } else {
            Rectangle2D.Double double_ = new Rectangle2D.Double(uClip.getX(), uClip.getY(), uClip.getWidth(), uClip.getHeight());
            ((Graphics2D)this.getGraphicObject()).setClip(double_);
        }
    }

    protected final double getDpiFactor() {
        return this.dpiFactor;
    }

    @Override
    public void startUrl(Url url) {
        this.urls.add(url);
    }

    @Override
    public void closeAction() {
        this.urls.remove(this.urls.size() - 1);
    }

    @Override
    public void ensureVisible(double d, double d2) {
        for (Url url : this.urls) {
            url.ensureVisible(d, d2);
        }
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    public Graphics2D getGraphics2D() {
        return (Graphics2D)this.getGraphicObject();
    }

    @Override
    public void writeImage(OutputStream outputStream, String string, int n) throws IOException {
        BufferedImage bufferedImage = this.getBufferedImage();
        PngIO.write((RenderedImage)bufferedImage, outputStream, string, n);
    }
}

