/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.visio;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.golem.MinMaxDouble;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.USegment;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.ugraphic.visio.VisioLine;
import net.sourceforge.plantuml.ugraphic.visio.VisioRectangle;
import net.sourceforge.plantuml.ugraphic.visio.VisioShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisioGraphics {
    private final List<VisioShape> shapes = new ArrayList<VisioShape>();
    private final MinMaxDouble limits = new MinMaxDouble();

    public void createVsd(OutputStream outputStream) throws IOException {
        double d = this.toInches(this.limits.getMaxX());
        double d2 = this.toInches(this.limits.getMaxY());
        this.out(outputStream, "<?xml version='1.0' encoding='utf-8' ?>");
        this.out(outputStream, "<VisioDocument xml:space='preserve' xmlns='http://schemas.microsoft.com/visio/2003/core' xmlns:vx='http://schemas.microsoft.com/visio/2006/extension' xmlns:v14='http://schemas.microsoft.com/office/visio/2010/extension'>");
        this.out(outputStream, "<DocumentProperties>");
        this.out(outputStream, "<Creator>PlantUML</Creator>");
        this.out(outputStream, "</DocumentProperties>");
        this.out(outputStream, "<DocumentSheet NameU='TheDoc' LineStyle='0' FillStyle='0' TextStyle='0'>");
        this.out(outputStream, "</DocumentSheet>");
        this.out(outputStream, "<Masters/>");
        this.out(outputStream, "<Pages>");
        this.out(outputStream, "<Page ID='0' NameU='Page-1' Name='Page 1' ViewScale='1' ViewCenterX='" + d / 2.0 + "' ViewCenterY='" + d2 / 2.0 + "'>");
        this.out(outputStream, "<PageSheet LineStyle='0' FillStyle='0' TextStyle='0'>");
        this.out(outputStream, "<PageProps>");
        this.out(outputStream, "<PageWidth Unit='IN_F'>" + d + "</PageWidth>");
        this.out(outputStream, "<PageHeight Unit='IN_F'>" + d2 + "</PageHeight>");
        this.out(outputStream, "<PageScale Unit='IN_F'>1</PageScale>");
        this.out(outputStream, "<DrawingScale Unit='IN_F'>2</DrawingScale>");
        this.out(outputStream, "<DrawingSizeType>3</DrawingSizeType>");
        this.out(outputStream, "<DrawingScaleType>0</DrawingScaleType>");
        this.out(outputStream, "<InhibitSnap>0</InhibitSnap>");
        this.out(outputStream, "</PageProps>");
        this.out(outputStream, "</PageSheet>");
        this.out(outputStream, "<Shapes>");
        for (VisioShape visioShape : this.shapes) {
            visioShape.yReverse(d2).print(outputStream);
        }
        this.out(outputStream, "</Shapes>");
        this.out(outputStream, "</Page>");
        this.out(outputStream, "</Pages>");
        this.out(outputStream, "</VisioDocument>");
    }

    private void out(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes());
        outputStream.write("\n".getBytes());
    }

    private double toInches(double d) {
        return d / 72.0;
    }

    private void ensureVisible(double d, double d2) {
        this.limits.manage(d, d2);
    }

    public void rectangle(double d, double d2, double d3, double d4) {
        this.ensureVisible(d, d2);
        this.ensureVisible(d + d3, d2 + d4);
        VisioRectangle visioRectangle = VisioRectangle.createInches(this.shapes.size() + 1, d, d2, d3, d4);
        this.shapes.add(visioRectangle);
    }

    public void line(double d, double d2, double d3, double d4) {
        this.ensureVisible(d, d2);
        if (d == d3 && d2 == d4) {
            return;
        }
        this.ensureVisible(d3, d4);
        VisioLine visioLine = VisioLine.createInches(this.shapes.size() + 1, d, d2, d3, d4);
        this.shapes.add(visioLine);
    }

    private void line(Point2D point2D, Point2D point2D2) {
        this.line(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void upath(double d, double d2, UPath uPath) {
        double d3 = d;
        double d4 = d2;
        for (USegment uSegment : uPath) {
            USegmentType uSegmentType = uSegment.getSegmentType();
            double[] dArray = uSegment.getCoord();
            if (uSegmentType == USegmentType.SEG_MOVETO) {
                d3 = dArray[0] + d;
                d4 = dArray[1] + d2;
                continue;
            }
            if (uSegmentType == USegmentType.SEG_LINETO) {
                this.line(d3, d4, dArray[0] + d, dArray[1] + d2);
                d3 = dArray[0] + d;
                d4 = dArray[1] + d2;
                continue;
            }
            if (uSegmentType == USegmentType.SEG_QUADTO) {
                this.line(d3, d4, dArray[2] + d, dArray[3] + d2);
                d3 = dArray[2] + d;
                d4 = dArray[3] + d2;
                continue;
            }
            if (uSegmentType == USegmentType.SEG_CUBICTO) {
                this.line(d3, d4, dArray[4] + d, dArray[5] + d2);
                d3 = dArray[4] + d;
                d4 = dArray[5] + d2;
                continue;
            }
            if (uSegmentType == USegmentType.SEG_CLOSE) continue;
            Log.println("unknown " + uSegment);
        }
    }

    public void polygon(UPolygon uPolygon) {
        Point2D.Double double_ = null;
        for (Point2D.Double double_2 : uPolygon.getPoints()) {
            if (double_ != null) {
                this.line(double_, double_2);
            }
            double_ = double_2;
        }
    }

    public void text(String string, double d, double d2, String string2, int n, double d3, Map<String, String> map) {
    }
}

