/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum License {
    GPL,
    LGPL,
    APACHE,
    EPL;


    public static License getCurrent() {
        return GPL;
    }

    private void addEpl(List<String> list) {
        list.add("PlantUML is free software; you can redistribute it and/or modify it");
        list.add("under the terms of the Eclipse Public License.");
        list.add("");
        list.add("THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC");
        list.add("LICENSE (\"AGREEMENT\"). [Eclipse Public License - v 1.0]");
        list.add("");
        list.add("ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES");
        list.add("RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.");
        list.add("");
        list.add("You may obtain a copy of the License at");
        list.add("");
        list.add("http://www.eclipse.org/legal/epl-v10.html");
        list.add("");
        list.add("Unless required by applicable law or agreed to in writing, software");
        list.add("distributed under the License is distributed on an \"AS IS\" BASIS,");
        list.add("WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
        list.add("See the License for the specific language governing permissions and");
        list.add("limitations under the License.");
        list.add("");
        list.add("Note that images (whatever their format : PNG, SVG...) generated by running PlantUML");
        list.add("are owned by the author of their corresponding sources code (that is, their");
        list.add("textual description in PlantUML language). Those images are not covered by");
        list.add("the Eclipse Public License.");
        list.add("");
        list.add("The generated images can then be used without any reference to the Eclipse Public License.");
        list.add("It is not even necessary to stipulate that they have been generated with PlantUML,");
        list.add("also this will be appreciate by PlantUML team.");
        list.add("");
        list.add("There is an exception : if the textual description in PlantUML language is also covered");
        list.add("by a license (like the EPL), then the generated images are logically covered");
        list.add("by the very same license.");
    }

    private void addApache(List<String> list) {
        list.add("PlantUML is free software; you can redistribute it and/or modify it");
        list.add("under the terms of the Apache Software License.");
        list.add("");
        list.add("Licensed under the Apache License, Version 2.0 (the \"License\");");
        list.add("you may not use this file except in compliance with the License.");
        list.add("You may obtain a copy of the License at");
        list.add("");
        list.add("http://www.apache.org/licenses/LICENSE-2.0");
        list.add("");
        list.add("Unless required by applicable law or agreed to in writing, software");
        list.add("distributed under the License is distributed on an \"AS IS\" BASIS,");
        list.add("WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
        list.add("See the License for the specific language governing permissions and");
        list.add("limitations under the License.");
        list.add("");
        list.add("Note that images (whatever their format : PNG, SVG...) generated by running PlantUML");
        list.add("are owned by the author of their corresponding sources code (that is, their");
        list.add("textual description in PlantUML language). Those images are not covered by");
        list.add("the Apache license.");
        list.add("");
        list.add("The generated images can then be used without any reference to the Apache license.");
        list.add("It is not even necessary to stipulate that they have been generated with PlantUML,");
        list.add("also this will be appreciate by PlantUML team.");
        list.add("");
        list.add("There is an exception : if the textual description in PlantUML language is also covered");
        list.add("by a license (like the Apache), then the generated images are logically covered");
        list.add("by the very same license.");
    }

    private void addGpl(List<String> list) {
        list.add("PlantUML is free software; you can redistribute it and/or modify it");
        list.add("under the terms of the GNU General Public License as published by");
        list.add("the Free Software Foundation, either version 3 of the License, or");
        list.add("(at your option) any later version.");
        list.add("");
        list.add("PlantUML distributed in the hope that it will be useful, but");
        list.add("WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY");
        list.add("or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public");
        list.add("License for more details.");
        list.add("");
        list.add("You should have received a copy of the GNU General Public");
        list.add("License along with this library; if not, write to the Free Software");
        list.add("Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,");
        list.add("USA.");
        list.add("");
        list.add("Note that images (whatever their format : PNG, SVG...) generated by running PlantUML");
        list.add("are owned by the author of their corresponding sources code (that is, their");
        list.add("textual description in PlantUML language). Those images are not covered by");
        list.add("the GPL license.");
        list.add("");
        list.add("The generated images can then be used without any reference to the GPL license.");
        list.add("It is not even necessary to stipulate that they have been generated with PlantUML,");
        list.add("also this will be appreciate by PlantUML team.");
        list.add("");
        list.add("There is an exception : if the textual description in PlantUML language is also covered");
        list.add("by a license (like the GPL), then the generated images are logically covered");
        list.add("by the very same license.");
    }

    private void addLgpl(List<String> list) {
        list.add("PlantUML is free software; you can redistribute it and/or modify it");
        list.add("under the terms of the GNU Lesser General Public License as published by");
        list.add("the Free Software Foundation, either version 3 of the License, or");
        list.add("(at your option) any later version.");
        list.add("");
        list.add("PlantUML distributed in the hope that it will be useful, but");
        list.add("WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY");
        list.add("or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public");
        list.add("License for more details.");
        list.add("");
        list.add("You should have received a copy of the GNU Lesser General Public");
        list.add("License along with this library; if not, write to the Free Software");
        list.add("Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,");
        list.add("USA.");
        list.add("");
        list.add("Note that images (whatever their format : PNG, SVG...) generated by running PlantUML");
        list.add("are owned by the author of their corresponding sources code (that is, their");
        list.add("textual description in PlantUML language). Those images are not covered by");
        list.add("the LGPL license.");
        list.add("");
        list.add("The generated images can then be used without any reference to the LGPL license.");
        list.add("It is not even necessary to stipulate that they have been generated with PlantUML,");
        list.add("although this will be appreciate by PlantUML team.");
        list.add("");
        list.add("There is an exception : if the textual description in PlantUML language is also covered");
        list.add("by a license (like the LGPL), then the generated images are logically covered");
        list.add("by the very same license.");
    }

    private List<String> getHeaderStart() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("========================================================================");
        arrayList.add("PlantUML : a free UML diagram generator");
        arrayList.add("========================================================================");
        arrayList.add("");
        arrayList.add("(C) Copyright 2009-2013, Arnaud Roques");
        arrayList.add("");
        arrayList.add("Project Info:  http://plantuml.sourceforge.net");
        arrayList.add("");
        return arrayList;
    }

    public List<String> getJavaHeader() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/* ========================================================================");
        arrayList.add(" * PlantUML : a free UML diagram generator");
        arrayList.add(" * ========================================================================");
        arrayList.add(" *");
        arrayList.add(" * (C) Copyright 2009-2013, Arnaud Roques");
        arrayList.add(" *");
        arrayList.add(" * Project Info:  http://plantuml.sourceforge.net");
        arrayList.add(" * ");
        arrayList.add(" * This file is part of PlantUML.");
        arrayList.add(" *");
        if (this == LGPL) {
            arrayList.add(" * PlantUML is free software; you can redistribute it and/or modify it");
            arrayList.add(" * under the terms of the GNU Lesser General Public License as published by");
            arrayList.add(" * the Free Software Foundation, either version 3 of the License, or");
            arrayList.add(" * (at your option) any later version.");
            arrayList.add(" *");
            arrayList.add(" * PlantUML distributed in the hope that it will be useful, but");
            arrayList.add(" * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY");
            arrayList.add(" * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public");
            arrayList.add(" * License for more details.");
            arrayList.add(" *");
            arrayList.add(" * You should have received a copy of the GNU Lesser General Public");
            arrayList.add(" * License along with this library; if not, write to the Free Software");
            arrayList.add(" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,");
            arrayList.add(" * USA.");
            arrayList.add(" *");
        } else if (this == APACHE) {
            arrayList.add(" * Licensed under the Apache License, Version 2.0 (the \"License\");");
            arrayList.add(" * you may not use this file except in compliance with the License.");
            arrayList.add(" * You may obtain a copy of the License at");
            arrayList.add(" * ");
            arrayList.add(" * http://www.apache.org/licenses/LICENSE-2.0");
            arrayList.add(" * ");
            arrayList.add(" * Unless required by applicable law or agreed to in writing, software");
            arrayList.add(" * distributed under the License is distributed on an \"AS IS\" BASIS,");
            arrayList.add(" * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
            arrayList.add(" * See the License for the specific language governing permissions and");
            arrayList.add(" * limitations under the License.");
            arrayList.add(" *");
        } else if (this == EPL) {
            arrayList.add(" * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC");
            arrayList.add(" * LICENSE (\"AGREEMENT\"). [Eclipse Public License - v 1.0]");
            arrayList.add(" * ");
            arrayList.add(" * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES");
            arrayList.add(" * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.");
            arrayList.add(" * ");
            arrayList.add(" * You may obtain a copy of the License at");
            arrayList.add(" * ");
            arrayList.add(" * http://www.eclipse.org/legal/epl-v10.html");
            arrayList.add(" * ");
            arrayList.add(" * Unless required by applicable law or agreed to in writing, software");
            arrayList.add(" * distributed under the License is distributed on an \"AS IS\" BASIS,");
            arrayList.add(" * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
            arrayList.add(" * See the License for the specific language governing permissions and");
            arrayList.add(" * limitations under the License.");
            arrayList.add(" * ");
        }
        arrayList.add(" *");
        arrayList.add(" * Original Author:  Arnaud Roques");
        arrayList.add(" */");
        return Collections.unmodifiableList(arrayList);
    }

    public List<String> getText() {
        List<String> list = this.getHeaderStart();
        if (this == GPL) {
            this.addGpl(list);
        } else if (this == EPL) {
            this.addEpl(list);
        } else if (this == APACHE) {
            this.addApache(list);
        } else if (this == LGPL) {
            this.addLgpl(list);
        } else {
            throw new IllegalStateException();
        }
        return list;
    }
}

