/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.command.PSystemSingleLineFactory1317;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemVersionFactory1317
extends PSystemSingleLineFactory1317 {
    protected AbstractPSystem executeLine(String string) {
        try {
            if (string.matches("(?i)^(authors?|about)\\s*$")) {
                return PSystemVersion.createShowAuthors();
            }
            if (string.matches("(?i)^version\\s*$")) {
                return PSystemVersion.createShowVersion();
            }
            if (string.matches("(?i)^testdot\\s*$")) {
                return PSystemVersion.createTestDot();
            }
            if (string.matches("(?i)^checkversion\\s*$")) {
                return PSystemVersion.createCheckVersions(null, null);
            }
            Pattern pattern = Pattern.compile("(?i)^checkversion\\(proxy=([\\w.]+),port=(\\d+)\\)$");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                return PSystemVersion.createCheckVersions(string2, string3);
            }
            Pattern pattern2 = Pattern.compile("(?i)^checkversion\\(proxy=([\\w.]+)\\)$");
            Matcher matcher2 = pattern2.matcher(string);
            if (matcher2.matches()) {
                String string4 = matcher2.group(1);
                return PSystemVersion.createCheckVersions(string4, "80");
            }
        }
        catch (IOException iOException) {
            Log.error("Error " + iOException);
        }
        return null;
    }
}

