#!/usr/bin/env python

import xml.etree.ElementTree as ET
import re

class Translator(object):
	def _slugify(self, sentence):
		return sentence.lower().replace(" ", "_")

	def add_noun(self, noun):
		if noun in self.klass.nouns.keys():
			return

		slug = self._slugify(noun)
		self.klass.current_noun = slug

		designation = ET.SubElement(self.klass.root, 'sbvr:designation')
		designation.set("xmi:id", slug)
		designation.set("xmi:signifier", "%s-t"%slug)
		designation.set("xmi:meaning", "%s-c"%slug)

		objectType = ET.SubElement(self.klass.root, 'sbvr:objectType')
		objectType.set("xmi:id", "%s-c"%slug)

		text = ET.SubElement(self.klass.root, 'sbvr:text')
		text.set("xmi:id", "%s-t"%slug)
		text.set("value", noun)

		self.klass.nouns[noun] = {
							"designation": designation,
							"objectType": objectType,
							"text": text}
		return self.klass.nouns[noun]

	def _generate_placeholder(self, slug_short, generic_subject, position):
		placeholder = ET.SubElement(self.klass.root, "sbvr:placeholder")
		placeholder.set("xmi:id", "%s-p1"%slug_short)
		placeholder.set("expression", "%s-t"%generic_subject)
		placeholder.set("startingCharacterPosition", "i%s" %position)
		placeholder.set("meaning", "%s-r1"%slug_short)

		placeholderUsesDesignation = ET.SubElement(self.klass.root, "sbvr:placeholderUsesDesignation")
		placeholderUsesDesignation.set("placeholder", "%s-p1"%slug_short)
		placeholderUsesDesignation.set("designation", generic_subject)

		concept1SpecializesConcept2 = ET.SubElement(self.klass.root, "sbvr:concept1SpecializesConcept2")
		concept1SpecializesConcept2.set("concept1", "%s-r1"%slug_short)
		concept1SpecializesConcept2.set("concept2", "%s-c"%generic_subject)

		factTypeRole = ET.SubElement(self.klass.root, "sbvr:factTypeRole")
		factTypeRole.set("xmi:id", "%s-r1"%slug_short)

		if not position in self.klass.declared_ints:
			positiveInteger = ET.SubElement(self.klass.root, "sbvr:positiveInteger")
			positiveInteger.set("xmi:id", "i%s"%position)
			positiveInteger.set("value", position)
			self.klass.declared_ints.append(position)

		return {
				"placeholder": placeholder,
				"placeholderUsesDesignation": placeholderUsesDesignation,
				"concept1SpecializesConcept2": concept1SpecializesConcept2,
				"factTypeRole": factTypeRole,
				}


	def add_sentence(self, sentence):
		elements = sentence.split()
		used_nouns = []
		for i in range(len(elements)):
			if i == 0:
				tmp_elem = " ".join(elements)
			else:
				tmp_elem = " ".join(elements[0:-i])
			if tmp_elem in self.klass.nouns.keys():
				used_nouns.append(tmp_elem)
				break
		for i in range(len(elements)):
			tmp_elem = " ".join(elements[i:])
			if tmp_elem in self.klass.nouns.keys():
				used_nouns.append(tmp_elem)
				break
		if len(used_nouns) == 1 and ('is exactly' in sentence or 'by exactly' in sentence):
			used_nouns.append(" ".join(elements[elements.index('exactly'):]))
		elif len(used_nouns) != 2:
			return
		pattern = "%s (.*) %s" %(used_nouns[0], used_nouns[1])
		m = re.match(pattern, sentence)
		if not m:
			return
		designation_name = m.groups()[0]
		noun_subject = self._slugify(used_nouns[0])
		noun_object = self._slugify(used_nouns[1])

		slug = sentence.title().replace(" ", "")
		slug_short = "".join([word[0] for word in sentence.lower().split()])

		sententialForm = ET.SubElement(self.klass.root, 'sbvr:sententialForm')
		sententialForm.set("xmi:id", slug)
		sententialForm.set("expression", "%s-t"%slug_short)
		sententialForm.set("meaning", "%s-c"%slug_short)
		sententialForm.set("placeholder", "%s-p1 %s-p2"%(slug_short, slug_short))

		factType = ET.SubElement(self.klass.root, 'sbvr:factType')
		factType.set("xmi:id", "%s-c"%slug_short)
		factType.set("role", "%s-r1 %s-r2"%(slug_short, slug_short))

		factTypeFormDemonstratesDesignation = ET.SubElement(self.klass.root, "sbvr:factTypeFormDemonstratesDesignation")
		factTypeFormDemonstratesDesignation.set("sbvr:factTypeForm", slug)
		factTypeFormDemonstratesDesignation.set("sbvr:designation", designation_name)

		designation = ET.SubElement(self.klass.root, "sbvr:designation")
		designation.set("xmi:id", designation_name)
		designation.set("signifier", "%s-t"%designation_name)
		designation.set("meaning", "%s-c"%slug_short)

		sentence_text = ET.SubElement(self.klass.root, "sbvr:text")
		sentence_text.set("xmi:id", "%s-t"%slug_short)
		sentence_text.set("value", sentence)

		designation_text = ET.SubElement(self.klass.root, "sbvr:text")
		designation_text.set("xmi:id", "%s-t"%designation_name)
		designation_text.set("value", designation_name)

		placeholder_subject = self._generate_placeholder(slug_short, noun_subject, str(sentence.index(used_nouns[0])+1))
		placeholder_object = self._generate_placeholder(slug_short, noun_object, str(sentence.index(used_nouns[1])+1))

		return {
				"sententialForm": sententialForm,
				"factType": factType,
				"factTypeFormDemonstratesDesignation": factTypeFormDemonstratesDesignation,
				"designation": designation,
				"sentence_text": sentence_text,
				"designation_text": designation_text,
				"placeholder_subject": placeholder_subject,
				"placeholder_object": placeholder_object,
		}


	def add_general_concept(self, params):
		if not self.klass.current_noun:
			return None
		concept1SpecializesConcept2 = ET.SubElement(self.klass.root, 'sbvr:concept1SpecializesConcept2')
		concept1SpecializesConcept2.set("concept1", "%s-c"%self._slugify(params[0]))
		concept1SpecializesConcept2.set("concept2", "%s-c"%self.klass.current_noun)

		return {"concept1SpecializesConcept2": concept1SpecializesConcept2}
