<?php

if(!defined('DOKU_INC')) define('DOKU_INC',realpath(dirname(__FILE__).'/../../').'/');
require_once(DOKU_INC.'inc/init.php');
if(!defined('DOKU_PLUGIN')) define('DOKU_PLUGIN',DOKU_INC.'lib/plugins/');
require_once(DOKU_PLUGIN.'sbvr/lexer.php');


class XMIGenerator{

	protected $lexer;
	protected $terms = array();
	protected $facts = array(); 
	protected $rules = array(); 

    public function __construct(){
        $this->lexer = new SbvrLexer();
    }

	public function generate($id){
		$this->prepareTerms(curNS($id));
		if(count($this->terms)==0)
			return 'no terms';
		$this->prepareFacts(curNS($id));
		if(count($this->facts)==0)
			return 'no facts';
		$this->prepareRules(curNS($id));
		if(count($this->rules)==0)
			return 'no rules';

		return $this->prepareFileContent($id);
	}

	private function prepareTerms($dir){
		$this->lexer->prepareTerms($dir);
		$this->terms = $this->lexer->terms;
	}
	
	private function prepareFacts($dir){
		$this->lexer->prepareFacts($dir);
		$this->facts = $this->lexer->facts;
	}

	private function prepareRules($dir){
		$this->lexer->prepareRules($dir);
		$this->rules = $this->lexer->rules;
	}

	private function prepareFileContent($id){
		$fileContent="";

		foreach($this->terms as $key => $term){
			$fileContent.=$term['name']."\n";			
		}

		foreach($this->facts as $key => $fact){
			$fileContent.=$fact['term1'].' '.$fact['verb'].' '.$fact['term2']."\n";
		}

		foreach($this->rules as $key => $rules){
			$fileContent.=trim($rules['rule'])."\n";
		}

		$file = DOKU_PLUGIN.'sbvr/tmp/'.curNS($id).'.txt';
		file_put_contents($file, $fileContent);

		$command = escapeshellcmd(DOKU_PLUGIN.'sbvr/python/sbvr2xmi.py '.$file);
		$output = shell_exec($command);
		return $output;
	}

}
