;(function ($) {

    /* Adds few useful things to canvas */

    CanvasRenderingContext2D.prototype.canvasPlus = {};

    CanvasRenderingContext2D.prototype.getDottedPattern = function(refresh) {
        if( !this.canvasPlus.dottedPattern || refresh){
            var w = 3*this.lineWidth;
            var dp = document.createElement('canvas');
            dp.width=w;
            dp.height=w;
            var context = dp.getContext("2d");
            context.fillStyle = this.strokeStyle;
            context.fillRect(0,0,2,2);
            this.canvasPlus.dottedPattern = this.createPattern(dp,'repeat');
        }
        return this.canvasPlus.dottedPattern;
    };

    CanvasRenderingContext2D.prototype.getLineHeight = function (refresh){
        if( !this.canvasPlus.lineHeight || refresh ) {
            var $d = $('<div></div>').css({
                'font': this.font,
                'visibility': 'hidden',
                'position': 'absolute',
                'top': 0,
                'left': 0
            }).text('`1234567890-=qwertyuiop[]\\asdfghjkl;\'zxcvbnm,./~!@#$%^&*()_+QWERTYUIOP{}|ASDFGHJKL:"ZXCVBNM<>?').appendTo('body');
            this.canvasPlus.lineHeight = $d.height();
            $d.remove();
        }
        return this.canvasPlus.lineHeight;
    };

    CanvasRenderingContext2D.prototype.getTextLines = function (text, maxWidth) {
        var lines = [];
        var words = text.split(" ");
        var line = "";
     
        for (var n = 0; n < words.length; n++) {
            var testLine = line + words[n] + " ";
            var metrics = this.measureText(testLine);
            var testWidth = metrics.width;
            if (testWidth > maxWidth) {
                lines.push(line);
                line = words[n] + " ";
            }
            else {
                line = testLine;
            }
        }
        if( $.trim(line).length ) {
            lines.push(line);
        }
        return lines;
    };

    CanvasRenderingContext2D.prototype.getTextHeight = function (text, maxWidth) {
        var lines = this.getTextLines(text,maxWidth);
        return this.getLineHeight(true)*lines.length;
    };

    CanvasRenderingContext2D.prototype.fillWrapText = function (text, x, y, maxWidth){
        var lines = this.getTextLines(text,maxWidth);

        for (var n = 0; n < lines.length; n++) {
            this.fillText(lines[n], x, y);
            y += this.getLineHeight();
        }
    };

    CanvasRenderingContext2D.prototype.strokeRoundedRect = function (x,y,w,h,r){
        this.beginPath();
        this.moveTo(x+r,y);
        this.lineTo(x+w-r, y);
        this.arcTo(x+w, y, x+w, y+r, r);
        this.lineTo(x+w, y+h-r);
        this.arcTo(x+w, y+h, x+w-r, y+h, r);
        this.lineTo(x+r, y+h);
        this.arcTo(x, y+h, x, y+h-r, r);
        this.lineTo(x, y+r);
        this.arcTo(x, y, x+15, y, r);
        this.stroke();
    };

})(jQuery);
