var Geometry = {

    /**
    * Return distance between two points
    */
    distance: function(start,end) {
        return Math.sqrt( Math.pow( start[0] - end[0], 2 ) + Math.pow( start[1] - end[1], 2 ) );
    },
    
    /**
     * Is point inside the box?
     */
    inside: function(box,point) {
       return point[0] > box[0] && point[0] < box[0] + box[2] && point[1] > box[1] && point[1] < box[1] + box[3]; 
    },
    
    /**
     * Does ab line cross cd line?
     */
    cross: function(a,b,c,d) {
        var detA = Geometry.det(c,d,a);
        var detB = Geometry.det(c,d,b);
        var detC = Geometry.det(a,b,c);
        var detD = Geometry.det(a,b,d);
        
        if( !detA || !detB || !detC || !detD ) {
            return (!detA && Geometry.in_range(c,d,a)) || (!detB && Geometry.in_range(c,d,b)) || (!detC && Geometry.in_range(a,b,c)) || (!detD && Geometry.in_range(a,b,d));
        } else {
            return Geometry.sign(detA) != Geometry.sign(detB) && Geometry.sign(detC) != Geometry.sign(detD);
        }
    },
    
    det: function(a,b,c){
        return a[0]*b[1] + b[0]*c[1] + c[0]*a[1] - c[0]*b[1] - a[0]*c[1] - b[0]*a[1]
    },
        
    in_range: function(a,b,c) {
        return Math.min(a[0], b[0]) <= c[0] && c[0] <= Math.max(a[0], b[0]) && Math.min(a[1], b[1]) <= c[1] && c[1] <= Math.max(a[1], b[1]);
    },
    
    sign: function(a) {
        return a > 0 ? 1 : (a < 0 ? -1 : 0);
    }

};
