<?php
/**
 * DokuWiki Plugin simplebpmn (Syntax Component)
 *
 * @license GPL 2 http://www.gnu.org/licenses/gpl-2.0.html
 * @author  Urszula Ciaputa <u.ciaputa@gmail.com>
 */

// must be run within Dokuwiki
if (!defined('DOKU_INC')) die();

if (!defined('DOKU_LF')) define('DOKU_LF', "\n");
if (!defined('DOKU_TAB')) define('DOKU_TAB', "\t");
if (!defined('DOKU_PLUGIN')) define('DOKU_PLUGIN',DOKU_INC.'lib/plugins/');

require_once DOKU_PLUGIN.'syntax.php';

class syntax_plugin_simplebpmn_bpmn extends DokuWiki_Syntax_Plugin {
    public function getType() {
        return 'container';
    }
    
    public function getAllowedTypes() {
        return array('substition');
    }

    public function getPType() {
        return 'block';
    }

    public function getSort() {
        return 195;
    }


    public function connectTo($mode) {
        $this->Lexer->addEntryPattern('<bpmn[^>]*>(?=.*?</bpmn>)',$mode,'plugin_simplebpmn_bpmn');
    }

    public function postConnect() {
        $this->Lexer->addExitPattern('</bpmn>','plugin_simplebpmn_bpmn');
    }

    public function handle($match, $state, $pos, &$handler){
        switch ($state) {
            case DOKU_LEXER_ENTER :
                return array($state, $match);
            case DOKU_LEXER_UNMATCHED :
                return array($state, $match);
            case DOKU_LEXER_EXIT :
                return  array($state, $match);
        }
        return array();
    }

    public function render($mode, &$renderer, $data) {
        if($mode != 'xhtml') return false;

        list($state,$match) = $data;
        switch ($state) {
            case DOKU_LEXER_ENTER :
                if( preg_match('/subprocesses=(collapse|expand)/i',$match,$subprc) && strtolower($subprc[1]) == 'expand' ){
                    $subprc = ' data-bpmn-subprc="expand"';
                } else {
                    $subprc = ' data-bpmn-subprc="collapse"';
                }
                
                if( preg_match('/diagram=(before|after)/i',$match,$diagram) && strtolower($diagram[1]) == 'after' ){
                    $diagram = ' data-bpmn-diagram="after"';
                } else {
                    $diagram = ' data-bpmn-diagram="before"';
                }
            
                $renderer->doc .= '<pre class="code bpmn-code"'.$subprc.$diagram.'>';
                break;
            case DOKU_LEXER_UNMATCHED :
                $renderer->doc .= $renderer->_xmlEntities($match);
                break;
            case DOKU_LEXER_EXIT :
                $renderer->doc .= '</pre>';
                break;
        }
        return true;
    }
}

// vim:ts=4:sw=4:et:
