<?php
/**
 * DokuWiki Plugin simplebpmn (Action Component)
 *
 * Based (and copy & pasted) on http://www.dokuwiki.org/plugin:templatebyname
 * plugin by Jan Van Opstal
 *
 * @license GPL 2 http://www.gnu.org/licenses/gpl-2.0.html
 * @author  Urszula Ciaputa <u.ciaputa@gmail.com>
 */

// must be run within Dokuwiki
if (!defined('DOKU_INC')) die();

if (!defined('DOKU_LF')) define('DOKU_LF', "\n");
if (!defined('DOKU_TAB')) define('DOKU_TAB', "\t");
if (!defined('DOKU_PLUGIN')) define('DOKU_PLUGIN',DOKU_INC.'lib/plugins/');

require_once DOKU_PLUGIN.'action.php';

class action_plugin_simplebpmn_findtemplate extends DokuWiki_Action_Plugin {

	public function register(Doku_Event_Handler $controller) {

	   $controller->register_hook('COMMON_PAGETPL_LOAD', 'BEFORE', $this, 'handle_common_pagetpl_load');

	}

	public function handle_common_pagetpl_load(Doku_Event &$event, $param) {
		global $conf;

		if(empty($event->data['tpl'])){

			if(empty($event->data['tplfile'])){

				$path = dirname(wikiFN($event->data['id']));
				$len = strlen(rtrim($conf['datadir'],'/'));
				$dir = substr($path, strrpos($path, '/')+1);
				$blnFirst = true;
				$blnFirstDir = true;
				$partArr = explode('_',noNS($event->data['id']),2);
				if( count($partArr) ) {
					$part = $partArr[0];
					while (strLen($path) >= $len){
						if($blnFirst == true && @file_exists($path.'/_'.$part.'.txt')){
							$event->data['tplfile'] = $path.'/_'.$part.'.txt';
							break;
						}
						elseif(@file_exists($path.'/__'.$part.'.txt')){
							$event->data['tplfile'] = $path.'/__'.$part.'.txt';
							break;
						}
						elseif($blnFirst == true && @file_exists($path.'/_template.txt')){
							$event->data['tplfile'] = $path.'/_template.txt';
							break;
						}
						elseif(@file_exists($path.'/__template.txt')){
							$event->data['tplfile'] = $path.'/__template.txt';
							break;
						}
						$path = substr($path, 0, strrpos($path, '/'));
						if($blnFirst == false){
							$blnFirstDir = false;
						}
						$blnFirst = false;
					}
				
					//fallback to plugin default templates
					if(empty($event->data['tplfile'])){
						$path = dirname(__FILE__).'/../templates';
						if( @file_exists($path.'/'.$part.'.txt') ) {
							$event->data['tplfile'] = $path.'/'.$part.'.txt';
						}
					}
				}
			}
			$event->data['tpl'] = io_readFile($event->data['tplfile']);
		}
		if($event->data['doreplace']) parsePageTemplate($event->data);
	}

}

