<?php
/**
 * DokuWiki Plugin simplebpmn (Syntax Component)
 *
 * Handles [[bpmn>...]] links responsible for including other pages bpmn code
 * into current page.
 *
 * @license GPL 2 http://www.gnu.org/licenses/gpl-2.0.html
 * @author  GEIST Research Group <krzysztof.kutt@uj.edu.pl
 */

// must be run within Dokuwiki
if (!defined('DOKU_INC')) die();

if (!defined('DOKU_LF')) define('DOKU_LF', "\n");
if (!defined('DOKU_TAB')) define('DOKU_TAB', "\t");
if (!defined('DOKU_PLUGIN')) define('DOKU_PLUGIN',DOKU_INC.'lib/plugins/');

require_once DOKU_PLUGIN.'syntax.php';

class syntax_plugin_simplebpmn_bpmninc extends DokuWiki_Syntax_Plugin {
	public function getType() {
		return 'substition';
	}
	
	public function getAllowedTypes() {
		return array();
	}

	public function getPType() {
		return 'normal';
	}

	public function getSort() {
		return 196;
	}


	public function connectTo($mode) {
		$this->Lexer->addSpecialPattern('[ \t]*\[\[bpmn>.+?\]\]',$mode,'plugin_simplebpmn_bpmninc');
	}

	public function handle($match, $state, $pos, $handler){
		switch ($state) {
			case DOKU_LEXER_SPECIAL :
				if ( preg_match('/([ \t]*)\[\[bpmn>(.+?)(?:\|(.+?))?\s*?\]\]/i',$match,$matches) ){
					return  array($state, $matches[2], $matches[3], $matches[1]);
				}
		}
		return array();
	}

	public function render($mode, $renderer, $data) {
		global $ID;
		if($mode != 'xhtml') return false;

		list($state,$page,$txt,$indent) = $data;
		switch ($state) {
			case DOKU_LEXER_SPECIAL :
				if( !$txt ) {
					$pieces = explode(':',$page);
					$txt = end($pieces);
				}
				resolve_pageid(getNS($ID),$page,$exists);
				$link = wl($page);
				$dom_available = class_exists('DOMDocument');
				$renderer->doc .= $indent.'<a href="'.$link.'" class="'.($exists ? 'wikilink1' : 'wikilink2').( !$exists || ($exists && $dom_available) ? ' bpmn-resolved' : '').'">'.$txt.'</a>';
				if( $exists && $dom_available ) {
					//get page code
					$xhtml = p_wiki_xhtml($page);
					$dom = new DOMDocument();
					@$dom->loadHTML($xhtml);
					$xpath = new DOMXPath($dom);
					$tags = $xpath->query("//*[contains(@class,'bpmn-code')][1]");
					if( count($tags) ) {
						foreach ($tags as $tag) {
							$lines = explode("\n",utf8_decode(trim($tag->nodeValue)));
							$renderer->doc .= ': '.implode("\n".$indent,$lines);
						}
					} else {
						$renderer->doc .= ': "'.$txt.'"';
					}
				} else if ( !$existst ) {
					$renderer->doc .= ': "'.$txt.'"';
				}
				break;
		}
		return true;
	}
}
