var scale = 0.5;
var tmp;
var width = 6000*scale,
	height = 3500*scale;

var force;
var columnsWidths = [];

// Ustawienia rozmiaru komórek
var cellHeight = 30*scale;
var cellWidth = 200*scale;

var tables = [];

function draw(t){
	
	tables = t;
	setSize(tables);
	
	// Przypisanie ilosci kolumn i wierszy do kazdej tabeli
	tables.forEach(function(table){
		//console.log(table);
		table.cols = table.conditions.length + table.decisions.length;
		table.rows = table.rules.length + 1;
		
		//console.log("Rozmiar tabeli: " +table.cols + ", " + table.rows);
	});
	
	// Ustalenie szerokości kulumn
	columnWidths = setColumnsWidths(tables);
	//console.log(columnWidths);
	//console.log("-----");
	//console.log(columnWidths);
	
	var table = tables[20];
	
	var svg = d3.select(".klasa").append("svg")
    	.attr("width", width)
    	.attr("height", height);
	
	showButtons(svg);
	expandCollapse("collapse");
	
    var j = -1;
    var k = 0;
	
	var links = setTablesLinks(tables);
	
	force = d3.layout.force()
	.charge(-20000)
    .nodes(d3.values(tables))
    .links(d3.values(links))
	.linkDistance(function(d){//console.log(d); 
			return (d.source.outLinks.length + d.target.inLinks.length)*50+20;}) // wczesniej: 800
    .size([width, height])
    .gravity(0.2)
	.friction(0.7)
	.theta(1.2)
    .start();
	
	
	
	svg.append("svg:defs").selectAll("marker")
    .data(["end"])      // Different link/path types can be defined here
  .enter().append("svg:marker")    // This section adds in the arrows
    .attr("id", String)
    .attr("viewBox", "0 -5 10 10")
    .attr("refX", 10)
    .attr("refY", 1)
    .attr("markerWidth", 6)
    .attr("markerHeight", 6)
    .attr("orient", "auto")
  .append("svg:path")
    .attr("d", "M0,-5L10,0L0,5");
	
	var link = svg.selectAll(".link")
    	.data(d3.values(links))
    	//.enter().append("line")
		.enter().append("svg:path")
      		.attr("class", "link")
			.attr("marker-end", "url(#end)");
      		//.style("stroke-width", function(d) { return Math.sqrt(d.value); });
	
	var tableGroup = svg.selectAll("tables").data(tables)
		.enter().append("svg:g")
		.call(force.drag);
		
	var drag = force.drag()
    	.on("dragstart", dragstart);
	
	force.on("tick", function() {
		
		tableGroup.attr("x", function(d){if (d.fixed); else if(d.inLinks.length == 0) return d.x = 40; else if (d.outLinks.length == 0) return d.x = (width-getTableWidth(d.id)-400); else return d.x = Math.max(50, Math.min(width - 50, d.x)); })
				.attr("y", function(d){return d.y = Math.max(70, Math.min(height - 50, d.y)); });
		
	  	tableGroup.attr("transform", function(d) { 
            return "translate(" + d.x + "," + d.y + ")"; });
	  	
	    //link.attr("x1", function(d) { return (d.source.x + getTableWidth(d.source)); })
	    //    .attr("y1", function(d) { return d.source.y; })
	    //    .attr("x2", function(d) { return d.target.x;})
	    //    .attr("y2", function(d) { return d.target.y; });
			
		link.attr("d", function(d) {
		    var dx = d.target.x - d.source.x,
		        dy = d.target.y - d.source.y,
		        dr = 0;//Math.sqrt(dx * dx + dy * dy);
		    return "M" + 
		        (d.source.x + getTableWidth(d.source)) + "," + 
		        d.source.y + "A" + 
		        dr + "," + dr + " 0 0,1 " + 
		        d.target.x + "," + 
		        d.target.y;
		});
	    
  	});
	
	

		// .attr("transform", function(d,i){
			// var x = 50;
			// var y = i*250;
			// return "translate("+x+","+y+")";
		// });
	
	var rows = tableGroup.append("svg:g").selectAll("tab_rows")
    	.data(function(d){
    		var rules = [], header = {};
			header.conditions = d.conditions;
			header.decisions = d.decisions;
			header.id = 0;
			rules[0] = header;
    		return jQuery.merge(rules, d.rules);
    	})
		.enter()
			.append("svg:g")
			.attr("class", function(d,i){if (i==0) return "header"; else return "non-header";})
			//.attr("transform", "translate("+(-200*scale)+","+(-10*scale)+")");
			.attr("transform", "translate("+-3+","+(-10*scale)+")");
			
	var cell = rows.selectAll("cell")
		.data(function(d){//console.log(jQuery.merge(jQuery.merge([],d.conditions),d.decisions)); 
						return jQuery.merge(jQuery.merge([],d.conditions),d.decisions);})
		.enter()
			.append("svg:g")
			.attr("transform", function(d,i){
				var id = d3.select(this.parentNode).datum().id;
				var parentId = d3.select(this.parentNode.parentNode).datum().id;
				//var x = i*(cellWidth+3*scale)+5*scale;
				//var x = i*(columnWidths[parentId][i]);//+3*scale)+5*scale;
				var x = 5*scale;
				if (i>0) x = sumArray(columnWidths[parentId],0,i-1)+5*scale;
				var y = id*(cellHeight+3*scale)+5*scale; 
				return "translate("+x+","+y+")";
				});
	
	cell.append("rect")
		.attr("class", function(d,i){//console.log(d); 
							var rowNum = d3.select(this.parentNode.parentNode).datum().id;
							var rowType;
							if (rowNum == 0) rowType = "header";
							else rowType = "non-header";
							var tabId = d3.select(this.parentNode.parentNode.parentNode).datum().id;
							return "id-cell "+tabId+"-"+i+" "+rowType;})
		//.attr("x", function(d, i){return i*150; })
		//.attr("y", function(d, i){if(i%3 == 0) j=j+1; return j*cellHeight;})
		//.attr("width", cellWidth)
		.attr("width", function(d,i){var parentId = d3.select(this.parentNode.parentNode.parentNode).datum().id; return columnWidths[parentId][i];})
		.attr("height", cellHeight)
		.on("dblclick", function(d){highlightColumns(d);});
		
	cell.append("text")
	.attr("class", function(d){if (d3.select(this.parentNode.parentNode).datum().id == 0) return "header"; else return "non-header";})
	.text(function(d){
		if (d3.select(this.parentNode.parentNode).datum().id == 0) return d;
		else return getSymbol(d.operator)+" "+d.value;})
	.attr("x", 30*scale)
    .attr("dy", 20*scale);
	
	//d3.values(tables)[14].x = 4000;
	//d3.values(tables)[14].fixed = true;
	
	//d3.values(tables)[20].fixed = true;
	
	//console.log(d3.values(tables));
			
	
}

function getSymbol(operator){
	switch(operator)
	{
	case "eq":
		return "=";
		break;
	case "neq":
		return "≠";
		break;
	case "in":
		return "∈";
		break;
	case "notin":
		return "∉";
		break;
	case "set":
		return ":=";
		break;
	case "lt":
		return "<";
		break;
	case "lte":
		return "≤";
		break;
	case "gt":
		return ">";
		break;
	case "gte":
		return "≥";
		break;
	default:
		return operator;
	}
}

function setColumnsWidths(tables){
	var widths = [];
	var columns, ruleColumns;
	tables.forEach(function(t,i){
		widths[t.id] = [];
		columns = jQuery.merge(jQuery.merge([],t.conditions),t.decisions);
		for (var j = 0; j < columns.length; j++){
			var maxWidth = columns[j].length;
			//console.log("przed: "+maxWidth);
			for (var k = 0; k < t.rules.length; k++){
				ruleColumns = jQuery.merge(jQuery.merge([],t.rules[k].conditions),t.rules[k].decisions);
				if (ruleColumns[j].value.length > maxWidth) maxWidth = ruleColumns[j].value.length;
				//console.log(ruleColumns[j].value.length);
			}
			//console.log("po: "+maxWidth);
			// TODO: Ustalanie szerokości
			//console.log(columns[j]);
			//console.log(columns[j].length);
			//widths[t.id][j] = 300*scale;
			widths[t.id][j] = (maxWidth*10 + 55)*scale;//(columns[j].length*10 + 55)*scale;
		}
	});
	//console.log(widths);
	return widths;
}

function sumArray(tab,a,b){
	var sum = 0;
	if (b<a) return -1;
	else{
		for (var i = a; i <= b; i++){
			sum = sum+tab[i];
		}
		return sum;
	}
}

function getTableWidth(table){
	//console.log(columnWidths[table.id]);
	return sumArray(columnWidths[table.id], 0, table.cols-1);
}

function getTableHeight(table){
	return table.rows*cellHeight;
}


function setTablesLinks(tables){
	var links = [];
	for (var i = 0; i < tables.length; i++){
		tables[i].outLinks = [];
		tables[i].inLinks = [];
	}
	for (var i = 0; i < tables.length; i++){
		var tabDecisions = tables[i].decisions;
		for (var j = 0; j < tabDecisions.length; j++){
			var attribute = tabDecisions[j];
			for (var k = 0; k < tables.length; k++){
				if (i!=k){
					var otherTabConditions = tables[k].conditions;
					for (var m = 0; m < otherTabConditions.length; m++){
						if (otherTabConditions[m] == attribute) {
							var link = {};
							link.source = i;
							link.target = k;
							links.push(link);
							// dodanie list tabel wchodzacych i wychodzacych
							tables[i].outLinks.push(tables[k].id);
							tables[k].inLinks.push(tables[i].id);
						}
					}
				}
			}
		}
	}
	
	function getStartTables(t){
		return jQuery.grep(t, function(e){ return e.inLinks.length == 0; });
	}
	
	function getEndTables(t){
		return jQuery.grep(t, function(e){ return e.outLinks.length == 0; });
	}
	
	return links;
}

function dragstart(d){
	d.fixed = true;
}

function highlightColumns(d){
	unhighlightAll();
	if(typeof(d)=="string"){
		for(var i = 0; i < tables.length; i++){
			var conDec = getCondDecMerged(tables[i]);
			if (conDec.indexOf(d)>=0){
				jQuery(".non-header.id-cell."+tables[i].id+"-"+conDec.indexOf(d)).css( "fill", "#9F57F7" );
				jQuery(".header.id-cell."+tables[i].id+"-"+conDec.indexOf(d)).css( "fill", "#673A9E" );
				//document.getElementById( "#id-cell-"+tables[i].id+"-"+conDec.indexOf(d) ).style.fill = "green";
			}
		}
	}
}

function getCondDecMerged(t){
	return jQuery.merge(jQuery.merge([],t.conditions),t.decisions);
}

function unhighlightAll(){
	jQuery(".id-cell").css( "fill", "" );
}

function showButtons(svg){
	var dataset = [
				{name:"expand", style: "expand", x:20, y:10, width:75, height:22}, 
				{name:"collapse", style:"collapse", x:20, y:35, width:75, height:22, id:"inc_on"},
				{name:"forces on", style:"collapse", x:130, y:10, width:80, height:22}, 
				{name:"forces off", style:"collapse", x:130, y:35, width:80, height:22, id:"inc_on"}
			];
		var buttons = svg.selectAll(".button")
			.data(dataset)
			.enter().append("g")
				.attr("class", function(d,i){return "button";});
		
		buttons.append("rect")
				.attr("x", function(d){return d.x})
				.attr("y", function(d){return d.y})
				.attr("width", function(d){return d.width;})
				.attr("height", function(d){return d.height;})
				.on("click", function(d){expandCollapse(d.name);})
				.attr("class", function(d,i){return "buttonRect";});
			             
		buttons.insert("text")
			.attr("x", function(d){return d.x+4;})
			.attr("y", function(d){return d.y+d.height/2+5;})
			.text(function(d) {return d.name;})
			.attr("class", function(d,i){return d.name+" labels";})
			.attr("id", function(d){return d.id;});
}

function expandCollapse(d){
	if (d=="expand"){
		jQuery(".klasa").css("position","absolute");
		jQuery("svg").css("width",width);
		jQuery("svg").css("height",height);
		jQuery(".expand.labels").css('fill','#7882f6');
		jQuery(".collapse.labels").css('fill','gray');
	}
	else if (d=="collapse"){
		var tmpWidth = jQuery(".page.group").css("width");
		jQuery(".klasa").css("position","relative");
		jQuery("svg").css("width",tmpWidth);
		jQuery("svg").css("height","240px");
		jQuery(".collapse.labels").css('fill','#7882f6');
		jQuery(".expand.labels").css('fill','gray');
	}
	else if (d == "forces on"){
		force.nodes().forEach(function(d){d.fixed = false;});
		jQuery(".forces.on").css('fill','#7882f6');
		jQuery(".forces.off").css('fill','gray');
	}
	else if (d == "forces off"){
		force.nodes().forEach(function(d){d.fixed = true;});
		jQuery(".forces.off").css('fill','#7882f6');
		jQuery(".forces.on").css('fill','gray');
	}
}

function setSize(t){
	if (t.length < 10){
		width = 3500*scale;
		height = 2000*scale;
	}
	else if (t.length < 20){
		width = 5000*scale;
		height = 2500*scale;
	}
	else{
		width = 6000*scale;
		height = 3500*scale;
	}
}
