<?php
/**
 * DokuWiki Plugin xttviewer (Syntax Component)
 *
 * @license GPL 2 http://www.gnu.org/licenses/gpl-2.0.html
 * @author  GEIST Research Group <krzysztof.kutt@uj.edu.pl>
 */

// must be run within Dokuwiki
if(!defined('DOKU_INC')) die();

class syntax_plugin_xttviewer extends DokuWiki_Syntax_Plugin {
    /**
     * @return string Syntax mode type
     */
    public function getType() {
        return 'protected';
        //return 'disabled';
    }
    /**
     * @return string Paragraph type
     */
    public function getPType() {
        return 'normal'; // normal, stack, block
    }
    /**
     * @return int Sort order - Low numbers go before high numbers
     */
    public function getSort() {
        return 999;
    }

    /**
     * Connect lookup pattern to lexer.
     *
     * @param string $mode Parser mode
     */
    public function connectTo($mode) {
        //$this->Lexer->addSpecialPattern('<hmr>',$mode,'plugin_xttviewer');
        $this->Lexer->addEntryPattern('<hmr>',$mode,'plugin_xttviewer');
    }

    public function postConnect() {
        $this->Lexer->addExitPattern('</hmr>','plugin_xttviewer');
    }

    /**
     * Handle matches of the xttviewer syntax
     *
     * @param string $match The match of the syntax
     * @param int    $state The state of the handler
     * @param int    $pos The position in the document
     * @param Doku_Handler    $handler The handler
     * @return array Data for the renderer
     */
    public function handle($match, $state, $pos, Doku_Handler $handler){
        switch ($state) {
          case DOKU_LEXER_ENTER : 
            break;
          case DOKU_LEXER_MATCHED :
            break;
          case DOKU_LEXER_UNMATCHED :
          $lines = explode("\n",$match);
          return array($state, $match);
            break;
          case DOKU_LEXER_EXIT :
            break;
          case DOKU_LEXER_SPECIAL :
            break;
        }
        return array();
    }

    /**
     * Render xhtml output or metadata
     *
     * @param string         $mode      Renderer mode (supported modes: xhtml)
     * @param Doku_Renderer  $renderer  The renderer
     * @param array          $data      The data from the handler() function
     * @return bool If rendering was successful.
     */
    public function render($mode, Doku_Renderer $renderer, $data) {
        list($state,$match) = $data;
        if($mode == 'xhtml') {
            switch ($state) {
            case DOKU_LEXER_ENTER :
            $renderer->doc .= 'some text';
              break;
            case DOKU_LEXER_MATCHED :
              break;
            case DOKU_LEXER_UNMATCHED :
            //$mat = var_dump($match);
            //$mat2 = explode("\n", $match);
            $mat2 = addslashes(json_encode($match));
            $plugin_path = DOKU_REL.'lib/plugins/xttviewer/';
            $renderer->doc .= "<div class=\"klasa\"></div>";
            //$renderer->doc .= "<script src=\"http://d3js.org/d3.v3.min.js\"></script>";
            $renderer->doc .= "<script src=".$plugin_path."d3/d3.v3.js"."></script>";
            $renderer->doc .= "<script src=".$plugin_path."jquery/jquery-2.0.3.js"."></script>";
            $renderer->doc .= "<script type=\"text/javascript\" src=".$plugin_path."drawer.js"."></script>";
            $renderer->doc .= "<script type=\"text/javascript\" src=".$plugin_path."parser.js"."></script>";
            $renderer->doc .= "<script language=\"javascript\">parse('$mat2');</script>";
            //$renderer->doc .= '<script type=\"text/javascript\" src=\"../lib/plugins/xttviewer/parser.js\"></script>';
            echo "<script type=\"text/javascript\" src=".$plugin_path."parser.js"."></script>";
            echo "<script type=\"text/javascript\" src=".$plugin_path."drawer.js"."></script>";
            echo "<script src=\"http://d3js.org/d3.v3.min.js\"></script>";
            //echo "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\">";
            //echo "<circle cx=\"100\" cy=\"50\" r=\"40\" stroke=\"black\" stroke-width=\"2\" fill=\"red\" /></svg>";
            //echo "<script language=\"javascript\">";
            //echo "parse('$mat2');";
            //echo "</script>";
            
              break;
            case DOKU_LEXER_EXIT :
              break;
            case DOKU_LEXER_SPECIAL :
              break;
          }
          return true;
        }
        return false;
    }
}

// vim:ts=4:sw=4:et:
